<?php

namespace Comitatus\Filter;

use Comitatus\Service\Database\DatabaseService;
use Comitatus\Validator\FieldExistValidator;
use Zend\InputFilter\InputFilter;
use Zend\Validator\NotEmpty;

class UserSettingsFilter extends InputFilter
{
    public function __construct($serviceLocator, $options = [])
    {
        $this->add(array(
            'name'       => 'notification_charge',
            'required'   => false,
        ));

        $this->add(array(
            'name'       => 'has_e_wallet_pin',
            'required'   => false,
        ));

        $this->add(array(
            'name'     => 'e_wallet_pin',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'       => 'max_daily_spending',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'     => 'payment_scheme',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'     => 'sms_ad',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'     => 'email_ad',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));
    }
}