<?php

namespace Comitatus\Filter;

use Zend\InputFilter\InputFilter;
use Zend\Validator\NotEmpty;

class SigninFilter extends InputFilter
{
    public function __construct()
    {
        $this->add(array(
            'name'       => 'username',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => NotEmpty::class,
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'       => 'password',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => NotEmpty::class,
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
                'name'     => 'remember_me',
                'required' => false,
            )
        );

        $this->add(array(
                'name'     => 'signinCsrf',
                'required' => false,
            )
        );
    }
}