<?php

namespace Comitatus\Filter;

use Zend\InputFilter\InputFilter;
use Zend\Validator\Date;
use Zend\Validator\NotEmpty;

class ScheduleFilter extends InputFilter
{
    public function __construct($serviceLocator)
    {
        $this->add(array(
            'name'       => 'name',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'       => 'year_start',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
                array(
                    'name'                   => 'Zend\Validator\Date',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'format' => 'm/d/Y',
                        'messages' => array(
                            Date::INVALID_DATE => 'Please input a valid date.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'       => 'year_end',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
                array(
                    'name'                   => 'Zend\Validator\Date',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'format' => 'm/d/Y',
                        'messages' => array(
                            Date::INVALID_DATE => 'Please input a valid date.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'     => 'is_active',
            'required' => false,
        ));

    }
}