<?php

namespace Comitatus\Filter;

use Comitatus\Service\Database\DatabaseService;
use Comitatus\Validator\FieldExistValidator;
use Zend\InputFilter\InputFilter;
use Zend\Validator\NotEmpty;

class ProfileFilter extends InputFilter
{
    public function __construct($serviceLocator)
    {
        $this->add(array(
            'name'       => 'first_name',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'       => 'last_name',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'     => 'middle_name',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'     => 'birthday',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'       => 'role',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'       => 'card_id',
            'required'   => false,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Comitatus\Validator\FieldExistValidator',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'serviceLocator' => $serviceLocator,
                        'table'          => DatabaseService::USER_TABLE,
                        'column'         => 'card_id',
                        'messages'       => array(
                            FieldExistValidator::VALUE_EXIST => 'Card ID is in use',
                        ),
                    ),
                ),
            ),

        ));

        $this->add(array(
            'name'       => 'email',
            'required'   => false,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Comitatus\Validator\FieldExistValidator',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'serviceLocator' => $serviceLocator,
                        'table'          => DatabaseService::USER_TABLE,
                        'column'         => 'email',
                        'messages'       => array(
                            FieldExistValidator::VALUE_EXIST => 'Email is in use',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'     => 'address',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'     => 'barangay',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'     => 'city',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'     => 'province',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'     => 'postal',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'     => 'mobile',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'     => 'telephone',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'     => 'level',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'     => 'section',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'     => 'learner_registration_number',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'     => 'payment_scheme',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'     => 'term',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'     => 'saveOption',
            'required' => false,
            'filters'  => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));
    }
}