<?php

namespace Comitatus\Filter;

use Zend\InputFilter\InputFilter;
use Zend\Validator\Digits;
use Zend\Validator\NotEmpty;

class AppSettingsFilter extends InputFilter
{
    public function __construct($serviceLocator)
    {
        $this->add(array(
            'name'       => 'default_theme',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'       => 'idle_time',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'       => 'idle_time_other',
            'required'   => false,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\Digits',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            Digits::NOT_DIGITS => 'Please input a number.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'       => 'max_sms',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
                array(
                    'name'                   => 'Zend\Validator\Digits',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            Digits::NOT_DIGITS => 'Please input a number',
                        ),
                    ),
                )
            ),
        ));

        $this->add(array(
            'name'       => 'max_credit',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
                array(
                    'name'                   => 'Zend\Validator\Digits',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            Digits::NOT_DIGITS => 'Please input a number',
                        ),
                    ),
                )
            ),
        ));

        $this->add(array(
            'name'       => 'reward_system',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'       => 'conversion_points',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'       => 'conversion_amount',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
            ),
        ));
    }
}