<?php
namespace Comitatus\Controller;

use Comitatus\Filter\SecureSigninFilter;
use Comitatus\Service\Account\AccountManager;
use Comitatus\Form\SecureSigninForm;
use Comitatus\Service\Database\DatabaseService;
use RrcomUserAccount\Auth\Adapter;
use Zend\Config\Config;
use Zend\Mvc\MvcEvent;
use Zend\View\Model\JsonModel;
use Zend\View\Model\ViewModel;

class SigninController extends \RrcomUserAccount\Controller\SigninController
{
    /** @var  AccountManager*/
    protected $accountManager;

    /** @var DatabaseService */
    protected $databaseService;

    /** @var Config */
    protected $config;

    public function indexAction()
    {
        $signinForm = new SecureSigninForm();
        $loginError = '';

        $request = $this->getRequest();
        if ($request->isPost()) {
            $signinFilter = new SecureSigninFilter();
            $signinFilter->setServiceLocator($this->serviceLocator);
            $signinForm->setInputFilter($signinFilter->getInputFilter());
            $signinForm->setData($request->getPost());

            if ($signinForm->isValid()) {
                $filter = $signinForm->getInputFilter();

                $this->switchDatabase($filter->getValue('signinAccount'));

                $authAdapter = new Adapter(
                    $filter->getValue('signinAccount'),
                    $filter->getValue('signinPassword'),
                    $this->serviceLocator
                );

                $this->authService()->logOut();
                if($filter->getValue('signinRememberMe') == 'yes') $this->authService()->rememberSession(true);
                $result = $this->authService()->authenticate($authAdapter);

                if($result->isValid()) {
                    if(!$this->accountManager->getCurrentUser()['account_closed']) return $this->redirect('validate');
                    $this->authService()->logOut();
                    $loginError = 'Account is disabled by admin';
                } else {

                    return new JsonModel(['status' => 0, 'msg' => '* Invalid username or password.']);
                }
            } else {
                return new JsonModel([
                    'status' => 0,
                    'msg' => '* Account not recognized.',
                    'errors' => $signinFilter->getInputFilter()->getMessages(),
                ]);
            }
        }

        $view = new ViewModel();
        $this->layout('layout/signin-layout');
//        $view->setTemplate('base-module/signin/index');
        $view->setVariables(array(
            'form' => $signinForm,
            'loginError' => $loginError,
            'signinUrl' => $this->redirect('signin', true),
        ));
        return $view;
    }

    private function switchDatabase($username)
    {
        if (substr($username, 0, 5) == 'admin') {
            $alias = '';
        } else {
            $alias = substr($username, 2, 1);
            $alias = 'db_'.$alias;
        }

        if ($alias != '') {
            $adapter = new \Zend\Db\Adapter\Adapter($this->config['db']['adapters'][$alias]);
            $this->databaseService->setDatabase($adapter);
            $this->accountManager->setDatabase($adapter);
        }
    }

    public function failedAction() {
        $view = new ViewModel();
        $this->layout('layout/base-module/signin-layout');
        $view->setTemplate('base-module/signin/failed');
        return $view;
    }

    public function onDispatch(MvcEvent $e)
    {
        $this->accountManager = $this->serviceLocator->get(AccountManager::class);
        $this->databaseService =  $this->serviceLocator->get(DatabaseService::class);
        $this->config =  $this->serviceLocator->get('Config');
        return parent::onDispatch($e);
    }


}
