<?php

namespace Comitatus\Controller;

use Comitatus\Filter\ScheduleFilter;
use Comitatus\Form\ScheduleForm;
use Comitatus\Service\Database\DatabaseService;
use Zend\View\Model\JsonModel;

class SchedulesController extends BaseController
{
    public function indexAction()
    {
        $schedules = [];
        $list      = $this->databaseService->selectData(DatabaseService::YR_SCHEDULE_TBL);

        if ($list->count()) {
            foreach ($list as $item) {
                $users         = $this->databaseService->selectData(DatabaseService::DY_SCHEDULE_TBL, ['year_id' => $item['id']]);
                $item['users'] = $users->count();
                $schedules[]   = $item;
            }
        }
        return [
            'schedules' => $schedules,
        ];
    }

    public function formAction()
    {
        $id       = $this->params('param1');
        $schedule = [];

        if (!empty($id)) {
            $schedule = $this->databaseService->selectData(DatabaseService::YR_SCHEDULE_TBL, ['id' => $id])->current();
        }

        if (strtolower($this->getRequest()->getMethod()) == 'post') {
            $action = strtolower($this->params('param1'));

            switch ($action) {
                case 'save':
                    $data       = $this->params()->fromPost('data', []);
                    $validation = $this->validateSchedule($data);
                    if ($validation['status'] == 0) {
                        return new JsonModel([
                            'status'  => 0,
                            'message' => 'Validation failed!',
                            'errors'  => $validation['message'],
                        ]);
                    }

                    $result = $this->saveSchedule($data);

                    return new JsonModel($result);
                    break;
                default:
                    break;
            }
        }

        return [
            'schedule' => $schedule,
        ];
    }

    private function validateSchedule($data)
    {
        $start  = date('Y-m-d', strtotime($data['year_start']));
        $end    = date('Y-m-d', strtotime($data['year_end']));
        $form   = new ScheduleForm($data);
        $filter = new ScheduleFilter($this->serviceLocator);

        $form->setInputFilter($filter);
        $form->setData($data);

        if ($form->isValid()) {
            $return['status']  = 1;
            $return['message'] = [];
        } else {
            $return['status']  = 0;
            $return['message'] = $filter->getMessages();
        }

        // validate if year start is greater than year end
        if ($start > $end) {
            $return['status']                        = 0;
            $return['message']['year_start']['err1'] = "Year start cannot be greater than year end.";
        }

        return $return;
    }

    private function saveSchedule($data)
    {
        $return = [];

        // check if is_active is true, deactivate other schedules
        if ($data['is_active']) {
            $this->databaseService->updateData2(DatabaseService::YR_SCHEDULE_TBL, ['is_active' => 0], []);
        }

        $schedule = [
            'name'        => $data['name'],
            'year_start'  => date('Y-m-d', strtotime($data['year_start'])),
            'year_end'    => date('Y-m-d', strtotime($data['year_end'])),
            'is_active'   => $data['is_active'] ? 1 : 0,
            'modified_by' => $this->userModified,
        ];

        //If scheduele doesn't exist,
        if ($data['id'] == '') {
            $this->databaseService->createData(DatabaseService::YR_SCHEDULE_TBL, $schedule);
            $return['status']  = 1;
            $return['message'] = 'Schedule Saved Successfully!';

        } else {
            $schedule['id'] = $data['id'];
            $this->databaseService->updateData(DatabaseService::YR_SCHEDULE_TBL, $schedule);
            $return['status']  = 1;
            $return['message'] = 'Schedule Updated Successfully!';
        }

        return $return;
    }

    public function getUserScheduleAction()
    {
        $id            = $this->params()->fromPost('id');
        $userSchedule  = $this->databaseService->selectData(DatabaseService::DY_SCHEDULE_TBL, ['user_id' => $id]);
        $dailySchedule = [];

        if ($userSchedule->count()) {
            foreach ($userSchedule as $dKey => $dValue) {
                $dailySchedule[$dKey] = $dValue;

                $timeInArr = explode(':', $dValue['time_in']);
                array_pop($timeInArr);
                $dailySchedule[$dKey]['time_in'] = implode(':', $timeInArr);

                $timeOutArr = explode(':', $dValue['time_out']);
                array_pop($timeOutArr);
                $dailySchedule[$dKey]['time_out'] = implode(':', $timeOutArr);
            }
        }

        return new JsonModel(['daily_schedule' => $dailySchedule]);
    }

    public function userScheduleFormAction()
    {
        $id        = $this->params('param1');
        $userInfo  = $this->accountManager->getUserInfo($id);
        $schedules = $this->databaseService->selectData(DatabaseService::YR_SCHEDULE_TBL);

        // for post request
        if (strtolower($this->getRequest()->getMethod()) == 'post') {
            $newSchedule = array();
            $schedules   = $this->params()->fromPost('schedules', []);
            $counter     = 0;

            foreach ($schedules as $key => $value) {
                $timeInArr               = explode(' ', $value['time_in']);
                $value['time_in']        = $timeInArr[0];
                $value['time_in_period'] = $timeInArr[1];

                $timeOutArr               = explode(' ', $value['time_out']);
                $value['time_out']        = $timeOutArr[0];
                $value['time_out_period'] = $timeOutArr[1];
                $value['day']             = str_replace(':', '', $value['day']);

                $value['modified_by'] = $this->userModified;

                if (isset($value['id'])) {
                    $updateDailySchedule = $this->databaseService->updateData(DatabaseService::DY_SCHEDULE_TBL, $value);
                    if ($updateDailySchedule->valid())
                        $counter++;

                } else {
                    $value['date_created'] = date('Y-m-d H:i:s');
                    $insertDailySchedule   = $this->databaseService->createData(DatabaseService::DY_SCHEDULE_TBL, $value);
                    if (intval($insertDailySchedule))
                        $counter++;
                }
            }

            if ($counter == 7) {
                return new JsonModel(['status' => 1, 'message' => 'Schedule Saved Successfully', 'src' => 'profile']);
            } else  return new JsonModel(['status' => 0, 'message' => 'Oops! Something went wrong. Please try again.']);

        }

        return [
            'user_info' => $userInfo,
            'schedules' => $schedules,
        ];
    }

    public function getSectionScheduleAction()
    {
        $sectionId       = $this->params()->fromPost('section_id');
        $levelId         = $this->params()->fromPost('level_id');
        $sectionSchedule = $this->databaseService->selectData(DatabaseService::SECTION_SCHEDULE_TBL, ['section_id' => $sectionId]);
        $dailySchedule   = [];

        if ($sectionSchedule->count()) {
            foreach ($sectionSchedule as $dKey => $dValue) {
                $dailySchedule[$dKey] = $dValue;

                $timeInArr = explode(':', $dValue['time_in']);
                array_pop($timeInArr);
                $dailySchedule[$dKey]['time_in'] = implode(':', $timeInArr);

                $timeOutArr = explode(':', $dValue['time_out']);
                array_pop($timeOutArr);
                $dailySchedule[$dKey]['time_out'] = implode(':', $timeOutArr);
            }
        }

        return new JsonModel(['daily_schedule' => $dailySchedule]);
    }

    public function sectionScheduleFormAction()
    {
        $level       = $this->params()->fromQuery('level', 0);
        $section     = $this->params()->fromQuery('section');
        $allLevels   = $this->databaseService->selectData(DatabaseService::LEVEL_TBL, ['is_archive' => 0]);
        $allSections = $this->databaseService->selectData(DatabaseService::SECTION_TBL, ['level_id' => $level, 'is_archive' => 0]);
        $levelInfo   = $this->databaseService->selectData(DatabaseService::LEVEL_TBL, ['id' => $level])->current();
        $sectionInfo = $this->databaseService->selectData(DatabaseService::SECTION_TBL, ['id' => $section])->current();
        $schedules   = $this->databaseService->selectData(DatabaseService::YR_SCHEDULE_TBL);

        // for post request
        if (strtolower($this->getRequest()->getMethod()) == 'post') {
            $yearId = $this->params()->fromPost('year_id');
            $schedules = $this->params()->fromPost('schedule', []);
            $counter   = 0;

            foreach ($schedules as $key => $value) {
                $timeInArr               = explode(' ', $value['time_in']);
                $value['time_in']        = $timeInArr[0];
                $value['time_in_period'] = $timeInArr[1];

                $timeOutArr               = explode(' ', $value['time_out']);
                $value['time_out']        = $timeOutArr[0];
                $value['time_out_period'] = $timeOutArr[1];
                $value['day']             = str_replace(':', '', $value['day']);

                $value['modified_by'] = $this->userModified;

                if (isset($value['id'])) {
                    $updateDailySchedule = $this->databaseService->updateData(DatabaseService::SECTION_SCHEDULE_TBL, $value);
                    if ($updateDailySchedule->valid())
                        $counter++;

                } else {
                    $value['date_created'] = date('Y-m-d H:i:s');
                    $insertDailySchedule   = $this->databaseService->createData(DatabaseService::SECTION_SCHEDULE_TBL, $value);
                    if (intval($insertDailySchedule))
                        $counter++;
                }
            }

            if ($counter == 7) {

                // update the schedule of the students under the section
                $sectionUsers = $this->databaseService->selectData(DatabaseService::USER_TABLE, ['section' => $section]);

                // update students' schedule with this section
                if ($sectionUsers->count()) {
                    foreach ($sectionUsers as $user) {
                        $this->databaseService->deleteData(DatabaseService::DY_SCHEDULE_TBL, ['user_id' => $user['id'], 'year_id' => $yearId]);
                        foreach ($schedules as $key => $value) {
                            unset($value['id'], $value['level_id'], $value['section_id']);

                            $timeInArr = explode(' ', $value['time_in']);
                            $value['time_in'] = $timeInArr[0];
                            $value['time_in_period'] = $timeInArr[1];

                            $timeOutArr = explode(' ', $value['time_out']);
                            $value['time_out'] = $timeOutArr[0];
                            $value['time_out_period'] = $timeOutArr[1];

                            $value['day'] = str_replace(':', '', $value['day']);
                            $value['user_id'] = $user['id'];
                            $value['modified_by'] = $this->userModified;
                            $value['date_created'] = date('Y-m-d H:i:s');

                            $this->databaseService->createData(DatabaseService::DY_SCHEDULE_TBL, $value);
                        }
                    }
                }

                return new JsonModel(['status' => 1, 'message' => 'Schedule Saved Successfully', 'src' => 'profile']);
            } else  return new JsonModel(['status' => 0, 'message' => 'Oops! Something went wrong. Please try again.']);

        }

        return [
            'sections'        => $allSections,
            'levels'          => $allLevels,
            'current_level'   => $levelInfo,
            'current_section' => $sectionInfo,
            'schedules'       => $schedules,
        ];
    }

    public function getSectionByLevelAction()
    {
        $levelId  = $this->params()->fromPost('level_id');
        $sections = $this->databaseService->selectData(DatabaseService::SECTION_TBL, ['level_id' => $levelId, 'is_archive' => 0], ["name ASC"]);
        $arr = [];

        if ($sections->count()) {
            foreach ($sections as $section) {
                $arr[] = $section;
            }
        }

        return new JsonModel(['sections' => $arr]);
    }
}