<?php

namespace Comitatus\Controller;

use Comitatus\Service\Excel\GenerateReport;

class ReportController extends BaseController
{
    public function generateAction()
    {
        /** @var GenerateReport $reportGenerator */
        $reportGenerator = $this->serviceLocator->get(GenerateReport::class);

        $data              = $this->params()->fromPost('data', []);
        $reportName        = $this->params()->fromPost('name');
        $reportDescription = $this->params()->fromPost('description');

        $values      = $data != '' ? json_decode($data, true) : [];
        $description = $reportDescription != '' ? json_decode($reportDescription, true) : [];
        $options     = [
            'current_user' => $this->currentUser['first_name'] . ' ' . $this->currentUser['last_name'],
            'title'        => $description['title'],
            'subject'      => $description['subject'],
            'file_name'    => $description['title'] . '_' . date('Y-m-d'),
            'data'         => $values,
        ];

        return $reportGenerator->createSpreadsheet($options);
    }
}