<?php

namespace Comitatus\Controller;

use Comitatus\Service\Database\DatabaseService;
use Zend\Db\Adapter\Adapter;
use Zend\Stdlib\ArrayUtils;
use Zend\View\Model\JsonModel;

class ChooseDatabaseController extends BaseController
{
    public function indexAction()
    {
        // set db connection to main db
        $this->databaseService->setDatabase($this->serviceLocator->get('main'));
        
        // for post data when selecting new database to manage
        if (strtolower($this->getRequest()->getMethod()) == 'post') {
            $databaseName        = $this->params()->fromPost('database-name');
            $databaseNameDisplay = $this->params()->fromPost('display');
            $currentYear         = $this->params()->fromPost('year-id');
            
            $this->sessionContainer->offsetSet('school_db', $databaseName);
            $this->sessionContainer->offsetSet('school_db_name', $databaseNameDisplay);
            $this->sessionContainer->offsetSet('current_year', $currentYear);
            
            return $this->redirect()->toRoute('base-module/default', ['controller' => 'accounts']);
        }
        
        // get all school databases
        $databases = $this->databaseService->selectData(DatabaseService::ADM_SCHOOL_TABLE, ['account_close' => 0], ['name ASC']);
        
        // set layout
        $this->layout('layout/modern-basic-layout');
        
        return [
            'is_dev'    => $this->sessionContainer['is_dev'],
            'databases' => $databases,
        ];
    }
    
    public function getSchoolYearAction()
    {
        $db = $this->params()->fromPost('db');
        if (empty($db)) return new JsonModel(['status' => 0, 'messages' => 'Invalid Request']);
        
        $adapter = $this->serviceLocator->get('db_' . intval($db));
        $this->databaseService->setDatabase($adapter);
        
        $schoolYear = $this->databaseService->selectData(DatabaseService::YR_SCHEDULE_TBL, [], ['year_end DESC']);
        $result     = ArrayUtils::iteratorToArray($schoolYear);
        return new JsonModel(['result' => $result]);
    }
}