<?php

namespace Comitatus\Controller;

use Comitatus\Filter\ProductFilter;
use Comitatus\Form\ProductForm;
use Comitatus\Service\Database\DatabaseService;
use Zend\View\Model\JsonModel;

class CanteenController extends BaseController
{
    public function indexAction()
    {
        return $this->redirect()->toRoute('base-module/default', ['controller' => 'canteen', 'action' => 'products']);
    }

    public function productsAction()
    {
        $products   = [];
        $list       = $this->databaseService->selectData(DatabaseService::CANTEEN_TBL);
        if ($list->count()) {
            foreach ($list as $item) {
                $item['facilities'] = $this->canteenService->getProductFacilities($item['id']);
                $products[]         = $item;
            }
        }

        if (strtolower($this->getRequest()->getMethod()) == 'post') {
            $action = strtolower($this->params('param1'));

            switch ($action) {
                case 'change-status':
                    $productId     = $this->params()->fromPost['id'];
                    $productStatus = $this->params()->fromPost['status'];

                    $data = [
                        'id'          => $productId,
                        'is_deleted'  => $productStatus,
                        'modified_by' => $this->userModified
                    ];

                    $update = $this->databaseService->updateData(DatabaseService::CANTEEN_TBL, $data);
                    if ($update->valid()) {
                        return new JsonModel(['status' => 1, 'message' => 'Product Status Updated Successfully']);
                    } else return new JsonModel(['status' => 0, 'message' => 'Oops! Something went']);

                    break;
                default:
                    break;
            }
        }

        return [
            'products'   => $products,
        ];

    }

    public function productFormAction()
    {
        $facilities = $this->databaseService->selectData(DatabaseService::CANTEEN_FAC_TBL);
        $id      = $this->params('param1');
        $product = [];

        if (!empty($id)) {
            $schedule = $this->databaseService->selectData(DatabaseService::CANTEEN_TBL, ['id' => $id])->current();
        }

        if (strtolower($this->getRequest()->getMethod()) == 'post') {
            $action = strtolower($this->params('param1'));

            switch ($action) {
                case 'save':
                    $data       = $this->params()->fromPost('data', []);
                    $validation = $this->validateProduct($data);
                    if ($validation['status'] == 0) {
                        return new JsonModel([
                            'status'  => 0,
                            'message' => 'Validation failed!',
                            'errors'  => $validation['message'],
                        ]);
                    }

                    $result = $this->saveProduct($data);

                    return new JsonModel($result);
                    break;
                default:
                    break;
            }
        }

        return [
            'product'    => $product,
            'facilities' => $facilities,
            'categories' => $this->serviceLocator->get('Config')['product-categories'],
        ];
    }

    private function validateProduct($data)
    {
        $form   = new ProductForm($data);
        $filter = new ProductFilter($this->serviceLocator);

        $form->setInputFilter($filter);
        $form->setData($data);

        if ($form->isValid()) {
            $return['status']  = 1;
            $return['message'] = [];
        } else {
            $return['status']  = 0;
            $return['message'] = $filter->getMessages();
        }

        return $return;
    }

    private function saveProduct($data)
    {
        $return = [];

        $product['modified_by'] = $this->userModified;

        //If product doesn't exist,
        if ($data['id'] == '') {
            $this->databaseService->createData(DatabaseService::CANTEEN_TBL, $product);
            $return['status']  = 1;
            $return['message'] = 'Product Saved Successfully!';

        } else {
            $product['id'] = $data['id'];
            $this->databaseService->updateData(DatabaseService::CANTEEN_TBL, $product);
            $return['status']  = 1;
            $return['message'] = 'Product Updated Successfully!';
        }

        return $return;
    }

    public function productInventoryAction()
    {
        return [
            'inventory' => [],
        ];
    }

    public function purchaseAction()
    {
        return [];
    }

    public function purchaseRecordsAction()
    {
        return [];
    }

    public function preorderAction()
    {
        return [];
    }

    public function preorderRecordsAction()
    {
        return [];
    }

    public function salesReportAction()
    {
        return [
            'totalCashSales'          => 0,
            'totalCashSalesAmount'    => 0,
            'totalEWalletSales'       => 0,
            'totalEWalletSalesAmount' => 0,
            'totalSales'              => 0,
            'totalSalesAmount'        => 0,
        ];
    }

    public function shoppingAction()
    {
        return [
            'rewardConversion'      => 'Test',
            'isRewardSystemEnabled' => 1,
            'categories'            => $this->serviceLocator->get('Config')['canteen-category'],
        ];
    }

    public function facilityAction()
    {
        $facilities = $this->databaseService->selectData(DatabaseService::CANTEEN_FAC_TBL);

        if (strtolower($this->getRequest()->getMethod()) == 'post') {
            $id     = $this->params()->fromPost('id');
            $name   = $this->params()->fromPost('name');
            $status = 0;
            $lastId = 0;

            $data = [
                'name'        => $name,
                'modified_by' => $this->userModified,
            ];

            if ($id != '' && intval($id) != 0) {
                $data['id'] = $id;
                $update     = $this->databaseService->updateData(DatabaseService::CANTEEN_FAC_TBL, $data);
                if ($update->valid()) {
                    return new JsonModel(['status' => 1, 'message' => 'Facility Updated Successfully']);
                } else return new JsonModel(['status' => 0, 'message' => 'Oops! Something went wrong']);
            } else {
                if ($name != '') {
                    $getFacility = $this->databaseService->selectData(DatabaseService::CANTEEN_FAC_TBL, ['name' => $name]);
                    if ($getFacility->count()) {
                        if ($getFacility->current()['id'] != $id) {
                            $status = 0;
                            return new JsonModel(['status' => $status, 'message' => 'Facility already exist!']);
                        }
                    } else {
                        $data['date_created'] = date('Y-m-d H:i:s');
                        $lastId               = $this->databaseService->createData(DatabaseService::CANTEEN_FAC_TBL, $data);

                        if (intval($lastId)) {
                            return new JsonModel(['status' => 1, 'message' => 'Facility Saved Successfully', 'last_id' => $lastId]);
                        } else return new JsonModel(['status' => 0, 'message' => 'Oops! Something went wrong']);

                    }
                }
            }
        }

        return [
            'facilities' => $facilities,
        ];
    }

    public function settingsAction()
    {
        return [];
    }
}