<?php

namespace Comitatus\Controller;

use Comitatus\Service\Account\AccountManager;
use Comitatus\Service\Canteen\CanteenService;
use Comitatus\Service\Database\DatabaseService;
use Comitatus\Service\EmailManager\EmailManager;
use Comitatus\Service\Image\ImageManager;
use Comitatus\Service\Session\SessionService;
use Comitatus\Service\SmsManager\SmsManager;
use Zend\Config\Config;
use Zend\Db\Adapter\Adapter;
use Zend\Mvc\Controller\AbstractActionController;
use Zend\Mvc\MvcEvent;
use Zend\Session\Container;

class BaseController extends AbstractActionController
{
    /** @var AccountManager */
    protected $accountManager;
    
    /** @var DatabaseService */
    protected $databaseService;
    
    /** @var CanteenService */
    protected $canteenService;
    
    /** @var EmailManager */
    protected $emailManager;
    
    /** @var SmsManager */
    protected $smsManager;
    
    /** @var ImageManager */
    protected $imageManager;
    
    /** @var Config */
    protected $config;
    
    /** @var SessionService */
    protected $sessionManager;
    
    /** @var Container */
    protected $sessionContainer;
    
    protected $currentUser;
    
    protected $currentUserAccessType;
    
    protected $currentUserAccessName;
    
    protected $userModified;
    
    public function onDispatch(MvcEvent $e)
    {
        // initialize most used services
        $this->emailManager     = $this->serviceLocator->get(EmailManager::class);
        $this->smsManager       = $this->serviceLocator->get(SmsManager::class);
        $this->accountManager   = $this->serviceLocator->get(AccountManager::class);
        $this->canteenService   = $this->serviceLocator->get(CanteenService::class);
        $this->databaseService  = $this->serviceLocator->get(DatabaseService::class);
        $this->imageManager     = $this->serviceLocator->get(ImageManager::class);
        $this->sessionManager   = $this->serviceLocator->get(SessionService::class);
        $this->config           = $this->serviceLocator->get('Config');
        $this->sessionContainer = $this->sessionManager->getSessionContainer('comitatus');
        
//        $this->sessionContainer = new Container('comitatus');
        
        $userSettings = [];
        
        // check if session exist; if not redirect to sign in
        if (!$this->sessionContainer->offsetExists('current_user')) {
            $redirect = $e->getRequest()->getServer('REQUEST_URI');
            return $this->redirect()->toRoute('base-module/default', array('controller' => 'signin'), array('query' => array('redir' => $redirect)));
        }
        
        // set current user information and access
        $this->currentUser = $this->sessionContainer->offsetGet('current_user');
        if (!isset($this->currentUser['access_permit']) && intval($this->currentUser['is_admin']) == 1) {
            $this->currentUserAccessName = 'admin';
            $this->currentUserAccessType = AccountManager::ACCESS_ADMIN;
            
            // set user modified by
            $this->userModified = '00' . $this->currentUser['id'];
        } else {
            $this->currentUserAccessName = $this->accountManager->getAccessRight($this->currentUser['access_permit']);
            $this->currentUserAccessType = $this->currentUser['access_permit'];
            
            $this->userModified = $this->currentUser['id'];
        }
        
        // point database connection to school databases
        if ($this->sessionContainer->offsetExists('school_db')) {
            $databaseName = $this->sessionContainer->offsetGet('school_db');
            
            // point to school
            if (isset($this->config['db']['adapters']['db_' . $databaseName])) {
                //                $adapterData = $this->config['db']['adapters']['db_' . $databaseName];
                //                $adapter     = new Adapter($adapterData);
                $adapter = $this->serviceLocator->get('db_' . $databaseName);
                $this->databaseService->setDatabase($adapter);
                $this->accountManager->setDatabase($adapter);
                $this->canteenService->setDatabase($adapter);
            }
        }
        
        
        // set layout variables
        $this->layout()->setVariables([
            'currentUser' => [
                'is_admin'  => $this->currentUser['is_admin'],
                'id'        => $this->currentUser['id'],
                'full_name' => $this->currentUser['first_name'] . ' ' . $this->currentUser['last_name'],
                'photo'     => isset($currentUser['photo']) ? $this->currentUser['photo'] : '',
                'theme'     => $this->currentUser['theme'],
            ],
        ]);
        
        return parent::onDispatch($e);
    }
}