<?php

namespace Comitatus\Controller;

use Comitatus\Service\Database\DatabaseService;
use Comitatus\Service\Password\PasswordService;
use Zend\Db\Adapter\Adapter;
use Zend\View\Model\JsonModel;

class AccountsController extends BaseController
{
    public function indexAction()
    {
        $levelId      = $this->params()->fromQuery('level', '');
        $userType     = $this->params()->fromQuery('user-type', 'a');
        $sectionId    = $this->params()->fromQuery('section', '');
        $listWhere    = [];
        $sectionWhere = [];
        $sections     = [];

        if ($userType == 's') {

            if (!empty($levelId)) {
                $listWhere['level']       = $levelId;
                $sectionWhere['level_id'] = $levelId;

                $sections = $this->databaseService->selectData(DatabaseService::SECTION_TBL, ['level_id' => $levelId, 'is_archive' => 0]);
            }

            if (!empty($sectionId)) {
                $listWhere['section'] = $sectionId;
            }
        }

        $list   = $this->accountManager->listAllUser($listWhere, $userType);
        $levels = $this->databaseService->selectData(DatabaseService::LEVEL_TBL, ['is_archive' => 0]);
        
        return [
            'access_type'    => $this->currentUserAccessType,
            'levels'         => $levels,
            'sections'       => $sections,
            'data'           => $list,
            'userType'       => $userType,
            'currentLevel'   => $levelId,
            'currentSection' => $sectionId,
        ];
    }

    public function changeAccountStatusAction()
    {
        $id     = $this->params()->fromPost('id');
        $status = $this->params()->fromPost('status');

        $update = $this->databaseService->updateData(DatabaseService::USER_TABLE, ['id' => $id, 'modified_by' => $this->userModified, 'account_close' => $status]);
        if ($update->valid())
            return new JsonModel(['status' => 1, 'msg' => 'Status changed successfully']);
        else return new JsonModel(['status' => 0, 'msg' => 'something went wrong']);
    }

    function resetPasswordAction()
    {
        /** @var PasswordService $passwordService */
        $passwordService = $this->serviceLocator->get(PasswordService::class);

        $modifiedBy = $this->currentUser['id'];

        $id        = $this->params()->fromPost('id');
        $fullName  = $this->params()->fromPost('full_name');
        $userId    = $this->params()->fromPost('user_id');
        $sendEmail = '';

        if ($id) {
            $isUser = $this->databaseService->selectData(DatabaseService::USER_TABLE, ['id' => $id]);

            if (count($isUser)) {
                $random = $passwordService->generateStrongPassword(8, false, 'luds');
                $token  = password_hash($random, PASSWORD_BCRYPT);
                $this->databaseService->updateData(DatabaseService::USER_TABLE, ['id' => $id, 'password' => $token, 'temp_key' => $random, 'modified_by' => $this->currentUser['id']]);

                //'contact@clairemontferrond.com'
                $emailList = ['jrwebapps@gmail.com',]; //admin email list

                $dateNow = date('m/d/Y h:i a');
                $subject = 'Comitatus Reset Password';

                $body = "Hi <strong>Admin</strong>" .
                    "<p>$fullName [$userId] is requesting a new password.</p><br>" .
                    "<p>This request was made on $dateNow</p>";

                foreach ($emailList as $email) {
                    //                    $this->emailManager->sendEmail($email, $subject, $body);

                    // create email logs
                    $emailLog = [
                        'recipient'    => $email,
                        'message'      => "[$subject]" . strip_tags($body),
                        'type'         => 'reset-pw-email',
                        'date_created' => $dateNow,
                        'modified_by'  => $this->userModified,
                    ];
                    $this->databaseService->createData(DatabaseService::EMAIL_LOGS_TBL, $emailLog);
                }

                $update = $this->databaseService->updateData(DatabaseService::USER_TABLE, ['id' => $id, 'reset_pw_token' => $token, 'modified_by' => $this->userModified]);
                if ($update->valid())
                    return new JsonModel(['status' => 1, 'msg' => 'Password Reset Successfully. Reload Page to view the temporary key']);
                else return new JsonModel(['status' => 0, 'msg' => 'Something went wrong. Try again.']);
            } else {
                return new JsonModel(['status' => 0, 'msg' => 'Something went wrong. Try again.']);
            }
        }
    }

    public function getUsersAction()
    {
        $databaseName = $this->sessionContainer->offsetGet('school_db');
        $adapterData  = $this->config['db']['adapters']['db_' . $databaseName];
        $adapter      = new Adapter($adapterData);
        $this->databaseService->setDatabase($adapter);

        $list  = $this->databaseService->selectData(DatabaseService::USER_TABLE);
        $users = [];

        foreach ($list as $key => $value) {
            $value['full_name'] = $value['first_name'] . ' ' . $value['last_name'];
            $value['status']    = $value['account_verified'] ? 'Active' : 'Pending';
            $value['role']      = $value['access_permit'];

            unset($value['access_permit']);

            $users[] = $value;
        }

        return new JsonModel(['data' => $users]);
    }
}