<?php

namespace Comitatus\Controller;

use Comitatus\Service\Database\DatabaseService;
use Zend\View\Model\JsonModel;

class AcademicController extends BaseController
{
    public function indexAction()
    {
        return [];
    }

    public function gradeLevelsAction()
    {
        $levels = $this->databaseService->selectData(DatabaseService::LEVEL_TBL);

        if (strtolower($this->getRequest()->getMethod()) == 'post') {
            $param = $this->params('param1');
            switch ($param) {
                case 'save':
                    $data                = $this->params()->fromPost('data');
                    $data['modified_by'] = $this->userModified;
                    $return              = [];

                    if ($data['id'] == '') {
                        unset($data['id']);
                        $data['date_created'] = date('Y-m-d H:i:s');
                        $this->databaseService->createData(DatabaseService::LEVEL_TBL, $data);
                        $return['status']  = 1;
                        $return['mode']    = 1;
                        $return['message'] = 'Level Saved Successfully!';

                    } else {
                        $this->databaseService->updateData(DatabaseService::LEVEL_TBL, $data);
                        $return['status']  = 1;
                        $return['mode']    = 2;
                        $return['message'] = 'Level Updated Successfully!';
                    }

                    return new JsonModel($return);

                    break;
                case 'archive':
                    $id        = $this->params()->fromPost('id');
                    $isArchive = $this->params()->fromPost('is_archive');

                    $update = $this->databaseService->updateData(DatabaseService::LEVEL_TBL, ['id' => $id, 'is_archive' => $isArchive]);
                    if ($update->valid()) {
                        $return['status']  = 1;
                        $return['message'] = 'Level status changed successfully!';
                    } else {
                        $return['status']  = 0;
                        $return['message'] = 'Something went wrong. Reload the page and try again.';
                    }

                    return new JsonModel($return);
                    break;
            }

        }

        return [
            'levels' => $levels,
        ];
    }

    public function gradingAction()
    {
        return [

        ];
    }
    
    public function clearanceAction()
    {
        return [];
    }

    public function sectionAction()
    {
        if (strtolower($this->getRequest()->getMethod()) == 'post') {

            $param = $this->params('param1');
            switch ($param) {
                case 'save':
                    $data                = $this->params()->fromPost('data');
                    $data['modified_by'] = $this->userModified;
                    $return              = [];

                    if ($data['id'] == '') {
                        $section = $this->databaseService->selectData(DatabaseService::SECTION_TBL, ['name' => $data['name'], 'level_id' => $data['level_id']]);
                        if ($section->count()) {
                            $return['status']  = 0;
                            $return['message'] = 'Section name already exist!';

                        } else {
                            unset($data['id']);
                            $data['date_created']  = date('Y-m-d H:i:s');
                            $insertedId            = $this->databaseService->createData(DatabaseService::SECTION_TBL, $data);
                            $return['status']      = 1;
                            $return['inserted_id'] = $insertedId;
                            $return['message']     = 'Section Saved Successfully!';
                        }

                    } else {
                        $this->databaseService->updateData(DatabaseService::SECTION_TBL, $data);
                        $return['status']      = 1;
                        $return['inserted_id'] = $data['id'];
                        $return['message']     = 'Section Updated Successfully!';
                    }

                    return new JsonModel($return);

                    break;
                case 'archive':
                    $id        = $this->params()->fromPost('id');
                    $isArchive = $this->params()->fromPost('is_archive');

                    $update = $this->databaseService->updateData(DatabaseService::SECTION_TBL, ['id' => $id, 'is_archive' => $isArchive]);
                    if ($update->valid()) {
                        $return['status']  = 1;
                        $return['message'] = 'Section status changed successfully!';
                    } else {
                        $return['status']  = 0;
                        $return['message'] = 'Something went wrong. Reload the page and try again.';
                    }

                    return new JsonModel($return);
                    break;
            }


        }
    }

    public function subjectAction()
    {
        if (strtolower($this->getRequest()->getMethod()) == 'post') {

            $param = $this->params('param1');
            switch ($param) {
                case 'save':
                    $data                = $this->params()->fromPost('data');
                    $data['modified_by'] = $this->userModified;

                    $return = [];

                    if ($data['id'] == '') {
                        $section = $this->databaseService->selectData(DatabaseService::SUBJECT_TBL, ['name' => $data['name'], 'level_id' => $data['level_id']]);
                        if ($section->count()) {
                            $return['status']  = 0;
                            $return['message'] = 'Section name already exist!';

                        } else {
                            unset($data['id']);
                            $data['date_created']  = date('Y-m-d H:i:s');
                            $insertedId            = $this->databaseService->createData(DatabaseService::SUBJECT_TBL, $data);
                            $return['status']      = 1;
                            $return['inserted_id'] = $insertedId;
                            $return['message']     = 'Section Saved Successfully!';
                        }

                    } else {

                        $this->databaseService->updateData(DatabaseService::SUBJECT_TBL, $data);
                        $return['status']      = 1;
                        $return['inserted_id'] = $data['id'];
                        $return['message']     = 'Section Updated Successfully!';
                    }

                    return new JsonModel($return);

                    break;
                case 'archive':
                    $id        = $this->params()->fromPost('id');
                    $isArchive = $this->params()->fromPost('is_archive');

                    $update = $this->databaseService->updateData(DatabaseService::SECTION_TBL, ['id' => $id, 'is_archive' => $isArchive]);
                    if ($update->valid()) {
                        $return['status']  = 1;
                        $return['message'] = 'Section status changed successfully!';
                    } else {
                        $return['status']  = 0;
                        $return['message'] = 'Something went wrong. Reload the page and try again.';
                    }

                    return new JsonModel($return);
                    break;
            }


        }
    }

    public function queryAction()
    {
        $return             = [];
        $return['subjects'] = [];
        $return['sections'] = [];
        $type               = $this->params()->fromQuery('type');
        $level              = $this->params()->fromQuery('level');

        if ($type == 'section') {

            $sections = $this->databaseService->selectData(DatabaseService::SECTION_TBL, ['level_id' => $level]);
            if ($sections->count()) {
                foreach ($sections as $section) {
                    $return['sections'][] = $section;
                }
            }

        }

        if ($type == 'subject') {
            $subjects = $this->databaseService->selectData(DatabaseService::SUBJECT_TBL, ['level_id' => $level]);
            if ($subjects->count()) {
                foreach ($subjects as $subject) {
                    $return['subjects'][] = $subject;
                }
            }
        }

        return new JsonModel($return);
    }
}