<?php
/** @var string $language Allowed language separated by pipe */
$language = 'pt-br|pt-pt|en-gb|zh-hans|zh-hant|en|de|it|fr|es|ja|id|vi|ko|ar|tr|th|ru|pl';

return array(
    'router' => array(
        'routes' => array(
            'base-module' => array(
                'type'          => 'Literal',
                'options'       => array(
                    'route'    => '/',
                    'defaults' => array(
                        '__NAMESPACE__' => 'BaseModule\Controller',
                        'controller'    => 'Profile',
                        'action'        => 'index',
                    ),
                ),
                'may_terminate' => true,
                'child_routes'  => array(
                    'default' => array(
                        'type'    => 'Segment',
                        'options' => array(
                            'route'       => '[:controller[/[:action[/[:param1[/[:param2[/]]]]]]]]',
                            'constraints' => array(
                                'controller' => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'action'     => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'param1'     => '[a-zA-Z0-9_-]*',
                                'param2'     => '[a-zA-Z0-9_-]*',
                            ),
                        ),
                    ),
                    'comitatus-rest-api' => array(
                        'type'    => 'Segment',
                        'options' => array(
                            'route'    => 'rest[/[:controller[/[:action[/[:param1[/[:param2[/]]]]]]]]]',
                            'constraints' => array(
                                'controller' => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'action'     => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'param1'     => '[a-zA-Z0-9_-]*',
                                'param2'     => '[a-zA-Z0-9_-]*',
                            ),
                            'defaults' => array(
                                '__NAMESPACE__' => 'BaseModule\Controller\Rest',
                                'controller'    => 'Index',
                                'action'        => 'index',
                            ),
                        ),
                    ),
                ),
            ),

            'mobile-global' => array(
                'type'          => 'Literal',
                'options'       => array(
                    'route'    => '/m',
                    'defaults' => array(
                        '__NAMESPACE__' => 'BaseModule\Controller',
                        'controller'    => 'Index',
                        'action'        => 'index',
                    ),
                ),
                'may_terminate' => true,
                'child_routes'  => array(
                    'default' => array(
                        'type'    => 'Segment',
                        'options' => array(
                            'route'       => '[/[:controller[/[:param1[/[:param2[/]]]]]]]',
                            'constraints' => array(
                                'controller' => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'param1'     => '[a-zA-Z0-9_-][a-zA-Z0-9_.-]*',
                                'param2'     => '[a-zA-Z0-9_-][a-zA-Z0-9_.-]*',
                            ),
                        ),
                    ),
                ),
            ),

            'desktop-localized' => array(
                'type'          => 'Zend\Mvc\Router\Http\Regex',
                'options'       => array(
                    'regex'    => "/(?<language>($language))",
                    'defaults' => array(
                        '__NAMESPACE__' => 'BaseModule\Controller',
                        'controller'    => 'Index',
                        'action'        => 'index',
                        'language'      => 'en',
                        'country'       => null,
                    ),
                    'spec'     => '/%language%',
                ),
                'may_terminate' => true,
                'child_routes'  => array(
                    'default' => array(
                        'type'    => 'Segment',
                        'options' => array(
                            'route'       => '[/[:controller[/[:param1[/[:param2[/]]]]]]]',
                            'constraints' => array(
                                'controller' => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'param1'     => '[a-zA-Z0-9_-][a-zA-Z0-9_.-]*',
                                'param2'     => '[a-zA-Z0-9_-][a-zA-Z0-9_.-]*',
                            ),
                        ),
                    ),
                ),
            ),

            'mobile-localized' => array(
                'type'          => 'Zend\Mvc\Router\Http\Regex',
                'options'       => array(
                    'regex'    => "/m/(?<language>($language))",
                    'defaults' => array(
                        '__NAMESPACE__' => 'BaseModule\Controller',
                        'controller'    => 'Index',
                        'action'        => 'index',
                        'language'      => 'en',
                        'country'       => null,
                    ),
                    'spec'     => '/m/%language%',
                ),
                'may_terminate' => true,
                'child_routes'  => array(
                    'default' => array(
                        'type'    => 'Segment',
                        'options' => array(
                            'route'       => '[/[:controller[/[:param1[/[:param2[/]]]]]]]',
                            'constraints' => array(
                                'controller' => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'param1'     => '[a-zA-Z0-9_-][a-zA-Z0-9_.-]*',
                                'param2'     => '[a-zA-Z0-9_-][a-zA-Z0-9_.-]*',
                            ),
                        ),
                    ),
                ),
            ),
        )
    ),
);
