<?php

namespace Comitatus;

use Zend\Mvc\ModuleRouteListener;
use Zend\Mvc\MvcEvent;
use Zend\Session\Container;
use Zend\Stdlib\Glob;
use Zend\Config\Factory;

class Module
{
    public function onBootstrap(MvcEvent $e)
    {
        // set default timezone
        date_default_timezone_set("Asia/Manila");
    }
    
    public function getConfig()
    {
        $config = array();
        $path   = sprintf(__DIR__ . '/config/{,*.}{global,%s}.php', ENV);
        foreach (Glob::glob($path, Glob::GLOB_BRACE) as $file) {
            $config = array_merge_recursive($config, Factory::fromFile($file));
        }
    
        unset($config['caches']['Cache\Persistence']['adapter']['options']['server']);
        
//        echo '<pre>';
//        print_r($config);
//        exit;
        
        return $config;
    }
    
    public function getAutoloaderConfig()
    {
        return array(
            'Zend\Loader\StandardAutoloader' => array(
                'namespaces' => array(
                    __NAMESPACE__ => __DIR__ . '/src/' . __NAMESPACE__,
                ),
            ),
        );
    }
}
