<?php
return array(
    /* Merge all module script to assets directory */
    'session'            => array(
        'config'                => array(
            //            'class'   => 'Zend\Session\Config\SessionConfig',
            'options' => array(
                'name' => SITE_NAME . '_session',
            ),
        ),
        //        'storage'               => 'Zend\Session\Storage\SessionArrayStorage',
        //        'validators'            => array(
        //            'Zend\Session\Validator\RemoteAddr',
        //            'Zend\Session\Validator\HttpUserAgent',
        //        ),
        'db_save_handler_table' => SITE_NAME . '_db_session',
        'auto_create_table'     => false,
    ),
    //    'session_config' => [
    //        'remember_me_seconds' => 2419200,
    //        'use_cookies' => true,
    //        'cookie_httponly' => true,
    //    ],
    'rrcom-user-account' => array(
        'user-table'        => SITE_NAME . '_user_account',
        'auth-db-table'     => SITE_NAME . '_auth_db_storage',
        'auto_create_table' => false,
    ),
    'site'               => array(
        'name'  => 'Comitatus',
        'email' => 'admin@clairemontferrond.tech',
    ),
    'navigation'         => array(
        'all'                => array(
            array(
                'label'      => 'System Settings',
                'route'      => 'base-module/default',
                'controller' => 'system-settings',
                'order'      => 1,
                'icon'       => 'fas fa-cogs fa-lg',
            ),
            array(
                'label'      => 'Account Manager',
                'route'      => 'base-module/default',
                'controller' => 'accounts',
                'order'      => 2,
                'icon'       => 'fas fa-users fa-lg',
            ),
            array(
                'label'      => 'Academics',
                'route'      => 'base-module/default',
                'controller' => 'academics',
                'order'      => 3,
                'icon'       => 'fas fa-graduation-cap fa-lg',
                'pages'      => array(
                    array(
                        'label'      => 'Grade Levels',
                        'route'      => 'base-module/default',
                        'controller' => 'academic',
                        'action'     => 'grade-levels',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Grading',
                        'route'      => 'base-module/default',
                        'controller' => 'academic',
                        'action'     => 'grading',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Moving Up Clearance',
                        'route'      => 'base-module/default',
                        'controller' => 'academic',
                        'action'     => 'clearance',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                ),
            ),
            array(
                'label'      => 'Schedules',
                'route'      => 'base-module/default',
                'controller' => 'schedules',
                'order'      => 3,
                'icon'       => 'fas fa-calendar-alt fa-lg',
            ),
            array(
                'label'      => 'Accounting',
                'route'      => 'base-module/default',
                'controller' => 'accounting',
                'order'      => 4,
                'icon'       => 'fas fa-calculator fa-lg',
                'pages'      => array(
                    array(
                        'label'      => 'Card Top-up',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'load-balance',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Topup Transactions',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'topup-transactions',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Payment Form',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'payment-form',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Payment Transactions',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'payment-transactions',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Discounts',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'discounts',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Print Bills',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'print-bills',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Top-up Report',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'topup-report',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Settings',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'settings',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                
                ),
            ),
            array(
                'label'      => 'Canteen',
                'route'      => 'base-module/default',
                'controller' => 'canteen',
                'order'      => 5,
                'icon'       => 'fas fa-utensils fa-lg',
                'pages'      => array(
                    array(
                        'label'      => 'Products',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'products',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Product Inventory',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'product-inventory',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Shopping',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'shopping',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Purchase',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'purchase',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Purchase Records',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'purchase-records',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Pre-order Form',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'preorder',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Pre-order Records',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'preorder-records',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Sales Report',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'sales-report',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Settings',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'settings',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                ),
            ),
            array(
                'label'      => 'Attendance',
                'route'      => 'base-module/default',
                'controller' => 'attendance',
                'order'      => 6,
                'icon'       => 'fas fa-book fa-lg',
                'pages'      => array(
                    array(
                        'label'      => 'New Record',
                        'route'      => 'base-module/default',
                        'controller' => 'attendance',
                        'action'     => 'new-record',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'View Records',
                        'route'      => 'base-module/default',
                        'controller' => 'attendance',
                        'action'     => 'index',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                ),
            ),
            array(
                'label'      => 'Announcement',
                'route'      => 'base-module/default',
                'controller' => 'announcement',
                'order'      => 7,
                'icon'       => 'fas fa-bullhorn fa-lg',
                'pages'      => array(
                    array(
                        'label'      => 'New Announcement',
                        'route'      => 'base-module/default',
                        'controller' => 'announcement',
                        'action'     => '',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'SMS Messaging',
                        'route'      => 'base-module/default',
                        'controller' => 'announcement',
                        'action'     => 'sms-blaster',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                ),
            ),
        ),
        'teacher'            => array(
            array(
                'label'      => 'Account Manager',
                'route'      => 'base-module/default',
                'controller' => 'accounts',
                'order'      => 1,
                'icon'       => 'fas fa-users fa-lg',
            ),
            array(
                'label'      => 'Academics',
                'route'      => 'base-module/default',
                'controller' => 'academics',
                'order'      => 2,
                'icon'       => 'fas fa-graduation-cap fa-lg',
                'pages'      => array(
                    array(
                        'label'      => 'Grade Levels',
                        'route'      => 'base-module/default',
                        'controller' => 'academic',
                        'action'     => 'grade-levels',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Grading',
                        'route'      => 'base-module/default',
                        'controller' => 'academic',
                        'action'     => 'grading',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                ),
            ),
            array(
                'label'      => 'Attendance',
                'route'      => 'base-module/default',
                'controller' => 'attendance',
                'order'      => 3,
                'icon'       => 'fas fa-book fa-lg',
                'pages'      => array(
                    array(
                        'label'      => 'New Record',
                        'route'      => 'base-module/default',
                        'controller' => 'attendance',
                        'action'     => 'new-record',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'View Records',
                        'route'      => 'base-module/default',
                        'controller' => 'attendance',
                        'action'     => 'index',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                ),
            ),
        ),
        'registrar'          => array(
            array(
                'label'      => 'Account Manager',
                'route'      => 'base-module/default',
                'controller' => 'accounts',
                'order'      => 1,
                'icon'       => 'fas fa-users fa-lg',
            ),
            array(
                'label'      => 'Academics',
                'route'      => 'base-module/default',
                'controller' => 'academics',
                'order'      => 2,
                'icon'       => 'fas fa-graduation-cap fa-lg',
                'pages'      => array(
                    array(
                        'label'      => 'Grade Levels',
                        'route'      => 'base-module/default',
                        'controller' => 'academic',
                        'action'     => 'grade-levels',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                ),
            ),
        ),
        'student'            => array(
            array(
                'label'      => 'Profile',
                'route'      => 'base-module/default',
                'controller' => 'profile',
                'order'      => 1,
                'icon'       => 'fas fa-users fa-lg',
            ),
        ),
        'canteen'            => array(
            array(
                'label'      => 'Canteen',
                'route'      => 'base-module/default',
                'controller' => 'canteen',
                'order'      => 5,
                'icon'       => 'fas fa-utensils fa-lg',
                'pages'      => array(
                    array(
                        'label'      => 'Products',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'products',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Product Inventory',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'product-inventory',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Shopping',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'shopping',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Purchase',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'purchase',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Purchase Records',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'purchase-records',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Pre-order Form',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'preorder',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Pre-order Records',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'preorder-records',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Sales Report',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'sales-report',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                ),
            ),
        ),
        'accounting-canteen' => array(
            array(
                'label'      => 'Accounting',
                'route'      => 'base-module/default',
                'controller' => 'accounting',
                'order'      => 4,
                'icon'       => 'fas fa-calculator fa-lg',
                'pages'      => array(
                    array(
                        'label'      => 'Card Top-up',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'load-balance',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Topup Transactions',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'topup-transactions',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Payment Form',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'payment-form',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Payment Transactions',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'payment-transactions',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                ),
            ),
            array(
                'label'      => 'Canteen',
                'route'      => 'base-module/default',
                'controller' => 'canteen',
                'order'      => 5,
                'icon'       => 'fas fa-utensils fa-lg',
                'pages'      => array(
                    array(
                        'label'      => 'Products',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'products',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Product Inventory',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'product-inventory',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Shopping',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'shopping',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Purchase',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'purchase',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Purchase Records',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'purchase-records',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Pre-order Form',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'preorder',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Pre-order Records',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'preorder-records',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Sales Report',
                        'route'      => 'base-module/default',
                        'controller' => 'canteen',
                        'action'     => 'sales-report',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                ),
            ),
        ),
        'accounting'         => array(
            array(
                'label'      => 'Accounting',
                'route'      => 'base-module/default',
                'controller' => 'accounting',
                'order'      => 4,
                'icon'       => 'fas fa-calculator fa-lg',
                'pages'      => array(
                    array(
                        'label'      => 'Card Top-up',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'load-balance',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Topup Transactions',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'topup-transactions',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Payment Form',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'payment-form',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                    array(
                        'label'      => 'Payment Transactions',
                        'route'      => 'base-module/default',
                        'controller' => 'accounting',
                        'action'     => 'payment-transactions',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                ),
            ),
        ),
        'security'           => array(
            array(
                'label'      => 'Attendance',
                'route'      => 'base-module/default',
                'controller' => 'attendance',
                'order'      => 6,
                'icon'       => 'fas fa-book fa-lg',
                'pages'      => array(
                    array(
                        'label'      => 'New Record',
                        'route'      => 'base-module/default',
                        'controller' => 'attendance',
                        'action'     => 'new-record',
                        'icon'       => 'fas fa-chevron-circle-right',
                    ),
                ),
            ),
        ),
        'basic'              => array(
            array(
                'label'      => 'My Profile',
                'route'      => 'base-module/default',
                'controller' => 'profile',
                'order'      => 1,
                'icon'       => 'fas fa-user fa-lg',
            ),
        ),
        'guest'              => array(
            array(
                'label'      => 'My Profile',
                'route'      => 'base-module/default',
                'controller' => 'profile',
                'order'      => 1,
                'icon'       => 'fas fa-user fa-lg',
            ),
        ),
        'employee'           => array(
            array(
                'label'      => 'My Profile',
                'route'      => 'base-module/default',
                'controller' => 'profile',
                'order'      => 1,
                'icon'       => 'fas fa-user fa-lg',
            ),
        ),
    ),
);