/** bootstrap notify **/
function notifyMe(options) {
    $.notify({
        // options
        title: options.title,
        message: options.msg
    }, {
        // settings
        type: options.type,
        delay: options.delay,
        animate: {
            enter: 'animated fadeInDown',
            exit: 'animated fadeOutUp'
        },
    });

    $('html, body').animate({scrollTop: $('section.content').top - 100}, 1000, 'swing', function () {
        // do nothing
    });
}

/** remove general errors **/
function removeErrors() {
    $('input, select, div, textarea, img').removeClass('errorBd');
    $('p.text-danger').remove();
}

/** get item from local storage **/
function get(name) {
    if (typeof (Storage) !== "undefined") {
        return localStorage.getItem(name);
    } else {
        console.log('Please use a modern browser to perform this action!');
    }
}

function onSkinSelect(e) {
    var skin = $(this).attr('data-class');

    console.log(skin);

    $.ajax({
        type: "POST",
        url: basePath + 'profile/update-skin',
        data: {skin: skin},
        error: function (jqXHR, textStatus, errorThrown) {
            console.log(textStatus, errorThrown);
        },
        success: function (response) {
            console.log(response);
        },
    });
}

(function ($) {
    function init() {
        $('.theme-settings-swatches .swatch-holder').on('click', onSkinSelect);

        $('.datepicker').datepicker({
            autoclose: true
        });
        $('.daterangepicker').daterangepicker();
        $(".timepicker").timepicker({
            showInputs: false
        });
        $('#daterange-btn').daterangepicker(
            {
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
                startDate: moment().subtract(29, 'days'),
                endDate: moment()
            },
            function (start, end) {
                $('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                $('#dateValue').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                $('#dateValue').trigger('change');
            }
        );
    }

    $(document).ready(init);

}(jQuery));