(function ($) {
    var parentImgUrl = typeof imageUrl != "undefined" ? imageUrl : '';
    var error = 0;
    var school_id = $('#schoolId');
    var defaultTheme = $('#themeSelector');
    var maxSms = $('#maxSMS');
    var autoLogout = $('#idleTimeSelector');
    var itOtherOpt = $('#itOther');
    var sendSms = $('#sendSMS');
    var maxCredit = $('#maxCredit');
    var rewardSystem = $('.reward-system');
    var conversionAmount = $('.conversion-amount');
    var conversionPoints = $('.conversion-points');

    function hideErrors() {
        $('select, input, div').removeClass('errorBd');
        $('.text-danger').remove();
    }

    function onThemeSelect() {
        var theme = $(this).find('option:selected').attr('data-color');
        console.log(theme);

        if (theme == '') $('.theme-preview-img').attr('src', parentImgUrl + 'image_1.jpg');
        else $('.theme-preview-img').attr('src', parentImgUrl + 'skins/' + theme + '.png');

        hideErrors();
    }

    function onAutoLogoutSelect() {
        var value = $(this).val();
        if (value == 'other') itOtherOpt.show();
        else itOtherOpt.hide();

        hideErrors();
    }

    function onSaveSettings() {

        var data = {
            id: school_id.val(),
            default_theme: defaultTheme.val(),
            theme_color: defaultTheme.find('option:selected').attr('data-color'),
            idle_time: autoLogout.val(),
            idle_time_other: itOtherOpt.val(),
            max_sms: maxSms.val(),
            send_sms_per_action: $('#sendSMS:checked').val(),
            max_credit: maxCredit.val(),
            reward_system: rewardSystem.prop('checked') ? 1 : 0,
            conversion_amount: conversionAmount.val(),
            conversion_points: conversionPoints.val(),
        };

        if (error == 0) {
            $.ajax({
                type: "POST",
                url: basePath + 'system-settings/index/save',
                data: {data: data},
                beforeSend: function() {
                    hideErrors();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    if (response.status == 1) {
                        notifyMe({
                            title: 'Success!',
                            msg: response.message,
                            type: 'success',
                            delay: 5000,
                        });
                    } else {
                        notifyMe({
                            title: 'Error!',
                            msg: response.message,
                            type: 'danger',
                            delay: 5000,
                        });

                        for (var input in response.errors) {
                            var errorMsg = response.errors[input][Object.keys(response.errors[input]).pop()];

                            if (input == 'idle_time' || input == 'default_theme') {
                                $('select[name="' + input + '"')
                                    .addClass('errorBd')
                                    .closest('.form-group').append('<p class="text-danger">' + errorMsg + '</p>');
                            }

                            if (input != 'conversion_amount') {
                                $('input[name="' + input + '"')
                                    .addClass('errorBd')
                                    .closest('.form-group').append('<p class="text-danger">' + errorMsg + '</p>');
                            } else $('input[name="' + input + '"').addClass('errorBd')
                        }
                    }

                },
                complete: function () {
                },
            });
        }
    }

    function init() {
        if (typeof current_controller != "undefined" && current_controller != 'SystemSettings') return;

        defaultTheme.on('change', onThemeSelect);
        autoLogout.on('change', onAutoLogoutSelect);
        $('#saveSettingsBtn').on('click', onSaveSettings);
    }

    $(document).ready(init);
}(jQuery));