(function ($) {

    var error = 0;
    var userId = $('#profileId').val();
    var errorBox = $('#schedule-error-box');
    var successBox = $('#schedule-success-box');

    /** section schedule variables **/
    var sectionId = $('#sectionId').val();
    var levelId = $('#levelId').val();
    var sectionXhr, saveSchedXhr, saveUserSchedXhr;

    function hideErrors() {
        error = 0;
        errorBox.find('p').remove();
        errorBox.hide();
        $('input').removeClass('errorBd');
    }

    /**
     * USER SCHEDULE SCRIPTS
     */
    function getSchedule() {
        if (userId != null && userId != '') {
            $.ajax({
                type: "POST",
                url: basePath + 'schedules/get-user-schedule',
                data: {id: userId},
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {

                    if (response.daily_schedule.length > 0) {
                        $.each(response.daily_schedule, function (i, e) {
                            var template = $('input[name="checkbox-' + e.day + '"]').closest('.sch-grp');
                            var isRestDay = e.is_restday == 1;

                            template.attr('data-id', e.id);
                            template.find('input[name="checkbox-' + e.day + '"]').prop('checked', isRestDay);
                            template.find('.timeIn').val(e.time_in + ' ' + e.time_in_period);
                            template.find('.timeOut').val(e.time_out + ' ' + e.time_out_period);
                        });
                    }
                },
            });
        }
    }

    function onScheduleSelect() {
        var valueSelected = $(this).val();
        var schedule = valueSelected.split('-');
        var dayFrom = schedule[0];
        var dayTo = schedule[1];
        var timeIn = schedule[2].length == 2 ? schedule[2] + ':00 AM' : '0' + schedule[2] + ':00 AM';
        var timeOut = schedule[3].length == 2 ? schedule[3] + ':00 AM' : '0' + schedule[3] + ':00 PM';

        //change the time for monday - friday
        for (var i = 0; i < 5; i++) {
            $('.timeIn').eq(i).val(timeIn);
            $('.timeOut').eq(i).val(timeOut);
        }

        //set the time for saturday - sunday to 00::00
        for (var x = 5; x < 8; x++) {
            $('.timeIn').eq(x).val('00:00 AM');
            $('.timeOut').eq(x).val('00:00 AM');
        }

        //check saturday - sunday as rest day
        $('input[name="checkbox-saturday"]').prop('checked', true);
        $('input[name="checkbox-sunday"]').prop('checked', true);
    }

    function onSaveUserSched(e) {
        e.preventDefault();
        var schedYear = $('#scheduleYearSelect');

        var scheduleToSave = [];
        $('.sch-grp').each(function () {
            var data = {
                id: $(this).attr('data-id'),
                user_id: userId,
                year_id: $('#scheduleYearSelect').val(),
                day: $(this).find('.dayName').text().toLowerCase(),
                time_in: $(this).find('.timeIn').val(),
                time_out: $(this).find('.timeOut').val(),
                is_restday: $(this).find('input[type="checkbox"]').prop('checked') == true ? 1 : 0,
            };
            scheduleToSave.push(data);
        });

        if (schedYear.val() == null) {
            schedYear.addClass('errorBd');
            notifyMe({
                title: 'Error!',
                msg: 'Please select a schedule',
                type: 'danger',
                delay: 5000,
            });
        } else {
            if (saveUserSchedXhr && saveUserSchedXhr.readyState != 4) saveUserSchedXhr.abort();
            saveUserSchedXhr = $.ajax({
                type: "POST",
                url: basePath + 'schedules/user-schedule-form',
                data: {schedules: scheduleToSave},
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {



                    if (response.status == 1) {
                        notifyMe({
                            title: 'Success!',
                            msg: response.message,
                            type: 'success',
                            delay: 5000,
                        });

                        if (response.src == 'profile') {
                            setTimeout(function () {
                                var profileId = $('#profileId').val();
                                localStorage.setItem('active_tab', '#my-schedule');
                                window.location.replace(basePath + 'profile/index/' + profileId);
                            }, 3000)
                        }

                    } else {
                        notifyMe({
                            title: 'Error!',
                            msg: response.message,
                            type: 'danger',
                            delay: 5000,
                        });
                    }
                },
            });
        }
    }

    function onSaveSchedule() {
        var yearId = $('#yearId').val();
        var yearFromInput = $('#yearFrom');
        var yearToInput = $('#yearTo');
        var scheduleName = $('#scheduleName');
        var is_active = $('#is_active');

        var data = {
            id: yearId,
            name: scheduleName.val(),
            year_start: yearFromInput.val(),
            year_end: yearToInput.val(),
            is_active: is_active.prop('checked'),
        };

        if (saveSchedXhr && saveSchedXhr.readyState != 4) saveSchedXhr.abort();
        saveSchedXhr = $.ajax({
            type: "POST",
            url: basePath + 'schedules/form/save',
            data: {data: data},
            beforeSend: function () {
                $('input').removeClass('errorBd');
                $('.text-danger').remove();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            },
            success: function (response) {


                if (response.status == 1) {
                    notifyMe({
                        title: 'Success!',
                        msg: response.message,
                        type: 'success',
                        delay: 5000,
                    });

                    setTimeout(function () {
                        window.location.replace(basePath + 'schedules');
                    }, 3000);
                } else {
                    notifyMe({
                        title: 'Error!',
                        msg: response.message,
                        type: 'danger',
                        delay: 5000,
                    });

                    for (var input in response.errors) {
                        var errorMsg = response.errors[input][Object.keys(response.errors[input]).pop()];
                        $('input[name="' + input + '"')
                            .addClass('errorBd')
                            .closest('.form-group').append('<p class="text-danger">' + errorMsg + '</p>');

                    }
                }
            },
        });
    }

    function onEnableDisableSchedule(e) {
        e.preventDefault();
        var button = $(this);
        var id = button.closest('tr').attr('data-id');
        var status = button.attr('data-status');

        var data = {
            id: id,
            status: status == 1 ? 0 : 1,
            schedule_status: true,
        };

        if (id) {
            $.ajax({
                type: "POST",
                url: 'functions/scheduleManager.php',
                data: data,
                beforeSend: function () {
                    $('#sch-stat-message').fadeOut('slow');
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    var resData = $.parseJSON(response);
                    if (resData.status == 'success') {
                        button.toggleClass(function () {
                            if (resData.is_active == 0) {
                                button.attr('data-status', 0);
                                button.html('<i class="fa fa-check"></i> ENABLE');
                                button.closest('tr').find('#statusText').text('Inactive');
                            } else {
                                button.attr('data-status', 1);
                                button.html('<i class="fa fa-ban"></i> DISABLE');
                                button.closest('tr').find('#statusText').text('Active');
                            }

                            return button.is('.btn-danger, .btn-warning') ? 'btn-danger btn-warning' : 'btn-danger';
                        });

                        $('#sch-stat-message').fadeIn('slow');
                    }
                },
            });
        }
    }


    /**
     * SCHEDULE PER SECTION
     *
     **/
    function getSectionSchedule() {

        if (sectionId != null && sectionId != '') {
            $.ajax({
                type: "POST",
                url: basePath + 'schedules/get-section-schedule',
                data: {section_id: sectionId},
                beforeSend: function () {
                    $('.loader-box').show();
                    $('.schedule-box').hide();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {


                    if (response.daily_schedule != null) {
                        $.each(response.daily_schedule, function (i, e) {
                            var template = $('input[name="checkbox-' + e.day + '"]').closest('.sch-grp');
                            var isRestDay = e.is_restday == 1;

                            template.attr('data-id', e.id);
                            template.find('input[name="checkbox-' + e.day + '"]').prop('checked', isRestDay);
                            template.find('.timeIn').val(e.time_in + ' ' + e.time_in_period);
                            template.find('.timeOut').val(e.time_out + ' ' + e.time_out_period);
                        });
                    }
                },
                complete: function () {
                    $('.loader-box').hide();
                    $('.schedule-box').show();
                }
            });
        } else {
            $('.loader-box').hide();
            $('.schedule-box').show();
        }
    }

    function getSectionByLevel() {
        var level_id = $(this).val();
        if (sectionXhr && sectionXhr.readyState != 4) {
            sectionXhr.abort();
        }

        sectionXhr = $.ajax({
            type: "POST",
            url: basePath + 'schedules/get-section-by-level',
            data: {level_id: level_id},
            beforeSend: function () {
                $('#scheduleGradeSection').addClass('loader');
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            },
            success: function (response) {


                $('#scheduleGradeSection').prop('disabled', true);
                $('#scheduleGradeSection option').not(':first-child').remove();

                if (response.sections.length > 0) {
                    $('#scheduleGradeSection').prop('disabled', false);
                    $.each(response.sections, function (i, e) {
                        $('#scheduleGradeSection').append(
                            '<option value="' + e.id + '">' + e.name + '</option>'
                        );
                    });
                }
            },
            complete: function () {
                $('#scheduleGradeSection').addClass('loader');
            }
        });
    }

    function saveSectionSchedule(e) {
        e.preventDefault();
        var schedYear = $('#scheduleYearSelect');
        var levelId = $('#scheduleGradeLevel');
        var sectionId = $('#scheduleGradeSection');
        var scheduleToSave = [];
        var error = 0;

        // remove error messages
        errorBox.find('p').remove();
        errorBox.hide();
        $('select').removeClass('errorBd');

        // get schedule by day
        $('.sch-grp').each(function () {
            var data = {
                id: $(this).attr('data-id'),
                level_id: levelId.val(),
                section_id: sectionId.val(),
                year_id: schedYear.val(),
                day: $(this).find('.dayName').text().toLowerCase(),
                time_in: $(this).find('.timeIn').val(),
                time_out: $(this).find('.timeOut').val(),
                is_restday: $(this).find('input[type="checkbox"]').prop('checked') == true ? 1 : 0,
            };
            scheduleToSave.push(data);
        });

        var toPost = {
            year_id: schedYear.val(),
            level_id: levelId.val(),
            section_id: sectionId.val(),
            schedule: scheduleToSave,
        };

        if (schedYear.val() == null) {
            schedYear.addClass('errorBd');
            schedYear.after('<p>* Please select a school year.</p>');
            error++;
        }
        if (levelId.val() == null) {
            levelId.addClass('errorBd');
            levelId.after('<p>* Please select a grade level.</p>');
            error++;
        }
        if (sectionId.val() == null) {
            sectionId.addClass('errorBd');
            sectionId.after('<p>* Please select a grade section.</p>');
            error++;
        }

        if (error == 0) {
            $.ajax({
                type: "POST",
                url: basePath + 'schedules/section-schedule-form',
                data: toPost,
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {


                    if (response.status == 1) {
                        notifyMe({
                            title: 'Success!',
                            msg: response.message,
                            type: 'success',
                            delay: 5000,
                        });
                    } else {
                        notifyMe({
                            title: 'Error!',
                            msg: response.message,
                            type: 'danger',
                            delay: 5000,
                        });
                    }

                },
            });
        }
    }

    function init() {
        if (current_controller != "undefined" && current_controller != 'Schedules') return;

        hideErrors();

        // general
        $('#scheduleSelect').on('change', onScheduleSelect);
        $('#saveSchedule').click(onSaveSchedule);
        $('.btn-change-status').on('click', onEnableDisableSchedule);
        $('#scheduleTable').DataTable({
            "paging": true,
            "lengthChange": true,
            "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "order": [[3, "asc"]],
            "columns": [
                null,
                null,
                null,
                null,
                null,
                {"orderable": false},
            ],
            "language": {
                "emptyTable": "No Results Found."
            }
        });

        // user schedule form event triggers
        if (action == "BaseModule/Controller/Schedules/section-schedule-form" ||
            action == "BaseModule/Controller/Schedules/user-schedule-form") {
            getSchedule();
            $('#saveScheduleBtn').off('click').on('click', onSaveUserSched);
        }

        // section schedule form event triggers
        if (action == "BaseModule/Controller/Schedules/section-schedule-form") {
            getSectionSchedule();
            $('#scheduleGradeLevel').on('change', getSectionByLevel);
            $('#saveSectionScheduleBtn').on('click', saveSectionSchedule);
        }
    }

    $(document).ready(init);
}(jQuery));