(function ($) {

        var addUserXhr, levelChangeXhr, saveProfileXhr,
            saveGuardianXhr, saveAppSettingsXhr;
        var bpTable;
        var bpHistoryTable;
        var bpMatrixTable;
        var profileCanteenTable;
        var profileAttendanceTable;
        var currentG;
        var saved_tab;

        function hideErrors() {
            $('input, div, img').removeClass('errorBd');
            $('.errorMsg').remove();
            $('p.text-danger').remove();
        }

        function onAddUser() {
            var inputs = $('#profile-form').find('input');
            var selects = $('#profile-form').find('select');

            var data = {};
            $(inputs).each(function () {
                var name = $(this).attr('name');
                var value = $(this).val().trim();

                if (typeof name != "undefined") data[name] = value;
            });

            $(selects).each(function () {
                var name = $(this).attr('name');
                var value = $(this).val().trim();

                if (typeof name != "undefined") data[name] = value;
            });

            if (addUserXhr && addUserXhr.readyState != 4) addUserXhr.abort();
            addUserXhr = $.ajax({
                type: "POST",
                url: basePath + 'profile/add-form',
                data: {data: data},
                dataType: 'json',
                beforeSend: function () {
                    removeErrors();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {


                    if (response.status == 0) {
                        for (var input in response.errors) {
                            var errorMsg = response.errors[input][Object.keys(response.errors[input]).pop()];
                            $('input[name="' + input + '"')
                                .addClass('errorBd')
                                .closest('.form-group').append('<p class="text-danger">' + errorMsg + '</p>');
                        }

                        notifyMe({
                            title: 'Error!',
                            msg: response.message,
                            type: 'danger',
                            delay: 5000,
                        });
                    } else {
                        notifyMe({
                            title: 'Success!',
                            msg: response.message,
                            type: 'success',
                            delay: 5000,
                        });

                        setTimeout(function () {
                            if (response.save_option == 1) window.location.replace(basePath + 'accounts');
                            else window.location.replace(basePath + 'schedule/form/' + response._guid);
                        }, 3000)
                    }

                },
                complete: function () {

                },
            });

        }

        function onAddProfileImageChange(e) {
            e.preventDefault();

            readFile(e.currentTarget.files[0], function (result) {
                $('#user-pp').attr('data-upload', 'true');
                $('#isUpload').val(1);
                $('#fileName').val(e.currentTarget.files[0]['name']);
            });
        }

        function readFile(file, callback) {
            var reader = new FileReader();

            reader.addEventListener('load', function () {
                var result = reader.result;
                $('#user-pp').attr('src', result);
                $('#imgSrc').val(result);

                callback(result);
            });
            if (file) reader.readAsDataURL(file);
        }

        function onLevelChange() {
            var level = $(this).val();
            $('#section').val('');
            $('#section option').not(':first').remove();

            if (level == '') {
                $('#section').val('');
                $('#section option').not(':first').remove();
            } else {
                if (levelChangeXhr && levelChangeXhr.readyState != 4) levelChangeXhr.abort();
                levelChangeXhr = $.ajax({
                    type: "POST",
                    url: basePath + 'rest/api/get-section-by-level',
                    data: {level_id: level},
                    beforeSend: function () {
                        $('#section').addClass('loading');
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    },
                    success: function (response) {
                        if (response.sections.length > 0) {
                            $.each(response.sections, function (i, e) {
                                if (e.is_archive == 0) {
                                    $('#section').append('<option value="' + e.id + '" class="text-muted">' + e.name + '</option>');
                                }
                            });
                        } else {
                            $('#section').append('<option value="" class="text-muted" disabled>No Section Found</option>');
                        }
                    },
                    complete: function () {
                        $('#section').removeClass('loading');

                    },
                });

            }
        }

        function onProfileTabSave() {
            hideErrors();

            var data = {
                id: $('#userId').val(),
                first_name: $('#first_name').val().trim(),
                last_name: $('#last_name').val().trim(),
                middle_name: $('#middle_name').val().trim(),
                email: $('#email').val().trim(),
                user_id: $('#user_id').val().trim(),
                card_id: $('#card_id').val().trim(),
                birthday: $('#birthday').val().trim(),
                address: $('#address').val().trim(),
                barangay: $('#barangay').val().trim(),
                city: $('#city').val().trim(),
                province: $('#province').val().trim(),
                postal: $('#postal').val().trim(),
                term: $('#term').val(),
                level: $('#level').val().trim(),
                section: $('#section').val().trim(),
                learner_registration_number: $('#learnerRegistrationNumber').val().trim(),
                mobile_number: $('#mobile').val().trim(),
                telephone_number: $('#phone').val().trim(),
                role: $('#role').val(),
            };


            if (saveProfileXhr && saveProfileXhr.readyState != 4) saveProfileXhr.abort();
            saveProfileXhr = $.ajax({
                type: "POST",
                url: basePath + 'profile/add-form',
                data: {data: data},
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {

                    if (response.status == 0) {
                        for (var input in response.errors) {
                            var errorMsg = response.errors[input][Object.keys(response.errors[input]).pop()];
                            $('input[name="' + input + '"')
                                .addClass('errorBd')
                                .closest('.form-group').append('<p class="text-danger">' + errorMsg + '</p>');
                        }

                        notifyMe({
                            title: 'Error!',
                            msg: response.message,
                            type: 'danger',
                            delay: 5000,
                        });
                    } else {
                        notifyMe({
                            title: 'Success!',
                            msg: response.message,
                            type: 'success',
                            delay: 5000,
                        });
                    }
                },
            });
        }


        /** Guardian Tab events **/

        function getGuardian() {
            var uId = $('#userId').val();
            var default_img = 'assets/img/image_1.jpg';

            if (uId) {
                $.ajax({
                    type: "GET",
                    url: basePath + 'profile/get-guardian-by-user-id/' + uId,
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    },
                    success: function (response) {
                        if (response.result.length > 0) {
                            $.each(response.result, function (i, e) {
                                var grp = $('.g-grp').eq(e.position);
                                var g_img = e.picture == '' || e.picture == null ? default_img : uploadUrl + '/users/guardians/' + e.picture;

                                grp.attr('data-id', e.id);
                                grp.find('.g-img').attr('src', g_img);
                                grp.find('.g-fname').val(e.first_name);
                                grp.find('.g-mname').val(e.middle_name);
                                grp.find('.g-lname').val(e.last_name);
                                grp.find('.g-email').val(e.email);
                                grp.find('.g-contact1').val(e.contact1);
                                grp.find('.g-contact2').val(e.contact2);
                                grp.find('.g-card-id').val(e.card_id);
                                grp.find('.g-relation').val(e.relation);
                                grp.find('.g-notif-email').prop('checked', e.email_notification == 1);
                                grp.find('.g-notif-sms').prop('checked', e.sms_notification == 1);

                                if (e.sms_notification == 1) grp.find('.g-notif-sms').prop('disabled', false);
                                if (e.email_notification == 1) grp.find('.g-notif-email').prop('disabled', false);
                                if (e.contact1 != null) grp.find('.g-notif-sms').prop('disabled', false);
                                if (e.email != null) grp.find('.g-notif-email').prop('disabled', false);
                            });
                        }
                    },
                });
            }
        }

        function onGuardianSave() {
            var guardian = [];
            var gError = 0;
            var user = $('#user_id').val();

            // get all the guardian details
            $('.g-grp').each(function () {
                var data = {
                    id: $(this).attr('data-id'),
                    first_name: $(this).find('.g-fname').val().trim(),
                    middle_name: $(this).find('.g-mname').val().trim(),
                    last_name: $(this).find('.g-lname').val().trim(),
                    email: $(this).find('.g-email').val().trim(),
                    contact1: $(this).find('.g-contact1').val().trim(),
                    contact2: $(this).find('.g-contact2').val().trim(),
                    card_id: $(this).find('.g-card-id').val().trim(),
                    relation: $(this).find('.g-relation').val().trim(),
                    email_notification: $(this).find('.g-notif-email').prop('checked') == true ? 1 : 0,
                    sms_notification: $(this).find('.g-notif-sms').prop('checked') == true ? 1 : 0,
                    user_id: $('#userId').val(),
                    position: $(this).index('.g-grp'),
                    img_src: $(this).find('.img-src').val(),
                    file_name: $(this).find('.file-name').val(),
                    is_upload: $(this).find('.is-upload').val(),
                };

                guardian.push(data);
            });

            $('.g-grp').eq(0).each(function () {
                var required = $(this).find('.req');
                required.each(function () {
                    if ($(this).val().trim() == '') {
                        $(this).addClass('errorBd');
                        gError++;
                    } else {
                        $(this).removeClass('errorBd')
                    }
                })
            });

            if (gError > 0) {
                notifyMe({
                    title: 'Error!',
                    msg: 'Please fill all the required fields.',
                    type: 'danger',
                    delay: 5000,
                });
            } else {
                $('#errorGBox')
                    .hide()
                    .find('p').remove();

                if (saveGuardianXhr && saveGuardianXhr.readyState != 4) saveGuardianXhr.abort();
                saveGuardianXhr = $.ajax({
                    type: "POST",
                    url: basePath + 'profile/save-guardian',
                    data: {data: guardian, user: user},
                    beforeSend: function () {
                        $('.g-grp').find('input').removeClass('errorBd');
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    },
                    success: function (response) {
                        if (response.status == 1) {
                            notifyMe({
                                title: 'Success!',
                                msg: response.message,
                                type: 'success',
                                delay: 5000,
                            });
                            setTimeout(function () {
                                location.reload();
                            }, 2500);

                        }
                        if (typeof response.errors != "undefined") {
                            $.each(response.errors, function (i, e) {
                                if (typeof e.emailAddressInvalidFormat != "undefined") {
                                    $('.g-email').eq(i).addClass('errorBd');
                                }
                            });

                            notifyMe({
                                title: 'Error!',
                                msg: 'Please put a valid email address',
                                type: 'danger',
                                delay: 5000,
                            });

                        }
                    },
                });

            }
        }

        function gReadFile(file, callback) {
            var reader = new FileReader();

            reader.addEventListener('load', function () {
                var result = reader.result;
                $('.g-img').eq(currentG).attr('src', result);
                $('.img-src').eq(currentG).val(result);

                callback(result);
            });
            if (file) reader.readAsDataURL(file);
        }

        function onGuardianImageChange(e) {
            e.preventDefault();
            gReadFile(e.currentTarget.files[0], function (result) {
                $('.g-img').eq(currentG).attr('data-upload', 'true');
                $('.is-upload').eq(currentG).val(1);
                $('.file-name').eq(currentG).val(e.currentTarget.files[0]['name']);
            });
        }

        /** End Guardian Tab events **/

        /** App Settings Tab **/
        function onAppSettingsSave(e) {
            var notif_charge = $('input[name="notification_charge"]:checked').val();
            var has_wallet_pin = $('input[name="has_e_wallet_pin"]:checked').val();
            var wallet_pin = $('#walletPin').val();
            var max_spending = $('#maxSpendingLimit').val();
            var payment_scheme = $('#paymentScheme').val();
            var sms_ad = $('#smsAd').is(':checked') ? 1 : 0;
            var email_ad = $('#emailAd').is(':checked') ? 1 : 0;

            var data = {
                user_id: $('#userId').val(),
                notification_charge: notif_charge == '1' ? 1 : 0,
                has_e_wallet_pin: has_wallet_pin == '1' ? 1 :0,
                e_wallet_pin: wallet_pin,
                max_daily_spending: max_spending,
                payment_scheme: payment_scheme,
                sms_ad: sms_ad,
                email_ad: email_ad,
            };

            if (saveAppSettingsXhr && saveAppSettingsXhr.readyState != 4) saveAppSettingsXhr.abort();
            saveAppSettingsXhr = $.ajax({
                type: "POST",
                url: basePath + 'profile/save-app-settings',
                data: {data: data},
                dataType: 'json',
                beforeSend: function() {
                    removeErrors();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    if (response.status == 1) {
                        notifyMe({
                            title: 'Success!',
                            msg: response.message,
                            type: 'success',
                            delay: 5000,
                        });
                    }
                    if (typeof response.errors != "undefined") {
                        for (var input in response.errors) {
                            var errorMsg = response.errors[input][Object.keys(response.errors[input]).pop()];
                            $('input[name="' + input + '"')
                                .addClass('errorBd')
                                .closest('.form-group').append('<p class="text-danger">' + errorMsg + '</p>');
                        }

                        notifyMe({
                            title: 'Error!',
                            msg: response.message,
                            type: 'danger',
                            delay: 5000,
                        });

                    }
                },
            });
        }

        /** End App Settings Tab **/

        function init() {

            if (typeof current_controller != "undefined" && current_controller != 'Profile') return;

            // profile add form event triggers
            $('#saveProfile').click(onAddUser);
            $('#level').change(onLevelChange);
            $('#editProfileImg').click(function () {
                $('#upload-user-pp').trigger('click');
            });
            $('#upload-user-pp').change(onAddProfileImageChange);

            // profile tab event triggers
            $('#saveMyProfile').on('click', onProfileTabSave);
            $('.profile-loader').hide();
            $('.profile-tabs ul li:first, .profile-tabs .tab-content .tab-pane:first').addClass('active');
            $('#change-profile-img').on('click', function (e) {
                e.preventDefault();
                $('#upload-pp').trigger('click');
            });

            // guardian tab
            $('#saveGuardian').on('click', onGuardianSave);
            $('.upload-g-img').change(onGuardianImageChange);
            $('.edit-img-btn').click(function () {
                currentG = $('.edit-img-btn').index(this);
                $('.upload-g-img').eq(currentG).trigger('click');
            });

            // pw tab
            $('#saveAppSetting').on('click', onAppSettingsSave);

            // for events on page load
            if (action == "BaseModule/Controller/Profile/index") {
                getGuardian();

                // switching active tab
                // get active tab on reload
                saved_tab = localStorage.getItem('active_tab');
                var current_tab = saved_tab == null ? '#my-wallet' : saved_tab;
                var tab_id = current_tab.replace('#', '');

                $('a[href="' + current_tab + '"]')
                    .attr('aria-expanded', true)
                    .parent()
                    .addClass('active')
                    .siblings()
                    .removeClass('active')
                    .find('a').attr('aria-expanded', false);

                $('div[id="' + tab_id + '"]')
                    .addClass('active')
                    .siblings().removeClass('active');

                // set active tab
                $('.profile-tabs ul li a').click(function () {
                    var active_tab = $(this).attr('href');
                    localStorage.setItem('active_tab', active_tab);
                });

                // contact and email event bindings
                $('.g-email').on('keyup', function () {
                    var group = $(this).closest('.g-grp');
                    if ($(this).val().length > 0) group.find('.g-notif-email').prop('disabled', false);
                    else group.find('.g-notif-email')
                        .prop('disabled', true)
                        .prop('checked', false);
                });

                $('.g-contact1, .g-contact2').on('keypress', function (e) {
                    if (e.which != 8 && isNaN(String.fromCharCode(e.which))) {
                        e.preventDefault(); //stop character from entering input
                    }
                });

                $('.g-contact1, .g-contact2').on('keyup', function () {
                    var group = $(this).closest('.g-grp');
                    var contact2 = group.find('.g-contact2').val();
                    if ($(this).val().length > 0) {
                        group.find('.g-notif-sms').prop('disabled', false);
                    } else {
                        group.find('.g-notif-sms').prop('disabled', true);
                        if (contact2 == '') group.find('.g-notif-sms').prop('disabled', true).prop('checked', false);
                        else group.find('.g-notif-sms').prop('disabled', false)
                    }
                });


                // dataTables declarations
                profileAttendanceTable = $('#profileAttendanceTable').DataTable({
                    "paging": true,
                    "lengthChange": true,
                    "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                    "searching": true,
                    "ordering": true,
                    "info": true,
                    "autoWidth": true,
                    // "order": [[0, "desc"]],
                    "aaSorting": [],
                    "language": {
                        "emptyTable": "No Results Found."
                    }
                });

                $('#profileCanteenTable').DataTable({
                    "paging": true,
                    "lengthChange": true,
                    "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                    "searching": true,
                    "ordering": true,
                    "info": true,
                    "autoWidth": true,
                    // "order": [[5, "desc"]],
                    "aaSorting": [],
                    "language": {
                        "emptyTable": "No Results Found."
                    }
                });

                $('#profileCanteenPreOrderTable').DataTable({
                    "paging": true,
                    "lengthChange": true,
                    "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                    "searching": true,
                    "ordering": true,
                    "info": true,
                    "autoWidth": true,
                    // "order": [[4, "desc"]],
                    "aaSorting": [],
                    "language": {
                        "emptyTable": "No Results Found."
                    }
                });
            }
        }

        $(document).ready(init);
    }

    (jQuery)
);