(function ($) {
    var loader = $('.loader-holder');
    var infoHolder = $('.info-holder');
    var syName = $('#aSchoolYearName');
    var syScope = $('#aSchoolYearScope');
    var attendanceTableContainer = $('#attendanceTableContainer');
    var userTypeInput = $('#userType');
    var levelInput = $('#level');
    var sectionInput = $('#section');
    var dateInput = $('#dateValue');
    var days = moment.weekdays();
    var d = new Date();
    var n = d.getDay(); // returns 0-6
    var h = (d.getHours() < 10 ? '0' : '') + d.getHours(); //to add leading zero
    var m = (d.getMinutes() < 10 ? '0' : '') + d.getMinutes(); //to add leading zero
    var t = h + ':' + m;
    var resultContainer = $('.user-search-result');
    var resultSet = [];
    var oTable;
    var isManual = 0;

    function hideFlags() {
        $('#flag-okay, #flag-late, #flag-no-sched, #flag-no-access').hide();
    }

    function resetPage() {
        $('#aUserName')
            .attr('data-id', '')
            .text('');
        $('#aUserLevel').text('');
        $('#atSearch').val('');
        $('#tapCard').val('');
        $('#aUserImg').attr('src', imgPlaceHolder);
    }

    function onUserSelect() {
        var aId = $(this).val();
        if (aId) onStartSearch($(this), aId);
        $('#tapCard').val(aId);
    }

    function displayTapStatus(param) {
        var data = {};
        hideFlags();

        if (typeof param == 'object') {
            for (var item in param) data[item] = param[item];
            data.tap_card = true;
            data.is_manual = isManual;
        }

        if (param) {
            $.ajax({
                type: "POST",
                data: data,
                url: basePath + 'attendance/get-schedule-by-user',
                beforeSend: function () {
                    loader.show();
                    hideFlags();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {

                    var students = response.students;
                    // display attendance status flag
                    switch (response.flag) {
                        case 0:
                            $('#flag-okay').show();
                            break;
                        case 1:
                            $('#flag-late').show();
                            break;
                        case 2:
                            $('#flag-no-sched').show();
                            break;
                        default:
                            $('#flag-no-access').show();
                            break;
                    }

                    // if guardian and has students
                    if (typeof students != "undefined") {
                        var st_len = students.length;
                        if (st_len > 0) {

                            $.each(students, function (s, t) {
                                var st_photo = t.picture !== '' || t.picture !== null ? upload_url + '/' + t.picture : imgPlaceHolder;
                                var stTemplate = $('.student-img-box-clone .st-img-box').clone();

                                stTemplate.find('.st-img').attr('src', st_photo);
                                stTemplate.find('.st-name').text(t.student_name);
                                stTemplate.find('.st-level').text(t.student_level);
                                stTemplate.find('.st-section').text(t.student_section);

                                $('#studentBox').append(stTemplate);
                            });

                            // add offsets for adjustments
                            if (st_len == 1) $('.st-img-box').eq(0).addClass('col-md-offset-4');
                            else if (st_len == 2) $('.st-img-box').eq(0).addClass('col-md-offset-2');
                        }

                    }

                    if (response.send_notification) sendNotifications();

                },
                complete: function () {
                    loader.hide();
                    $('#userSearch').val('');

                    setTimeout(function () {
                        resetPage();
                        hideFlags();
                        $('#studentBox').empty();
                    }, 5000);
                },
            });
        } else {
            hideFlags();
        }
    }

    function onLevelChange(e) {
        var lvl = $(this).val();
        if (lvl != '') {
            $('#filterForm').submit();
        } else {
            $('#section').prop('disabled', true);
        }
    }

    function onUserTypeChange() {
        var user_type = $(this);

        if (user_type.val().length > 0) {
            if (user_type.val() == 's') {
                levelInput.prop('disabled', false);
            } else {
                levelInput.prop('disabled', true);
                sectionInput.prop('disabled', true);
            }

            $('#attendanceSearchBtn').prop('disabled', false);

        } else {
            levelInput.prop('disabled', true);
            sectionInput.prop('disabled', true);
            $('#attendanceSearchBtn').prop('disabled', true);
        }

    }

    function onUserSearch() {
        var input = $(this);
        var resultList = $('#user-result-list');
        resultList.html('');
        resultSet = [];
        hideFlags();

        if (input.val() < 3) resultContainer.hide();

        // input.autocomplete({
        //     minLength: 3,
        //     source: function (request, response) {
        //         var term = $.trim(request.term);
        var term = $.trim(input.val());
        var pattern = /[a-z]/i;
        if (pattern.test(term)) isManual = 1;
        else isManual = 0;

        $.ajax({
            url: basePath + 'rest/api/search-user',
            type: 'GET',
            data: {search: term},
            error: function (jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            },
            beforeSend: function () {
                // input.val(''); // removed input value after tap
                input.addClass('loading');
                resultContainer.hide();
            },
            success: function (response) {
                var result = response.hits;

                if (!result.length) {
                    resultList.append('<li> No result for "' + term + '"</li>');
                    resultList.css('pointerEvents', 'none');
                    $('#flag-no-access').show();

                    accessDenied(term);
                    setTimeout(function () {
                        $('#flag-no-access').hide();
                        $('#userSearch').val('');
                        $('.user-search-result.s-box').hide();
                        location.reload();
                    }, 1000)
                } else {
                    $.each(result, function (key, obj) {
                        resultSet.push(obj);
                        resultList.css({'pointerEvents': 'auto', 'cursor': 'pointer'});
                        resultList.append('<li class="u-result" data-type="' + obj.type + '" data-id="' + obj.id + '" data-key="' + key + '">' + obj.first_name + ' ' + obj.last_name + '</li>');
                    });
                }

                $('.u-result').on('click', onUserResultClick);

            },
            complete: function () {
                term = '';
                input.removeClass('loading');
                resultContainer.show();
                if (resultSet.length == 1) onUserResultClick();
            },
        });
        // }
        // });
    }

    function onUserResultClick() {
        var selected = '';
        var ind = $(this).attr('data-key');
        if (typeof ind == 'undefined') ind = 0;

        selected = resultSet[ind];
        if (selected != null) {
            // $('#userSearch').val(selected['name']);
            var photo = selected.picture !== '' || selected.picture !== null ? selected.picture : imgPlaceHolder;
            var values = {
                id: selected['id'],
                full_name: selected['first_name'] + ' ' + selected['last_name'],
                user_type: selected['role'] == 2 ? 'student' : 'user',
            };

            $('#aUserImg').attr('src', photo);
            $('#aUserName')
                .attr('data-id', selected.id)
                .html('<strong>' + selected.first_name + ' ' + selected.last_name + '</strong>');
            $('#aUserLevel').text(selected.level_name);

            displayTapStatus(values);
        }
        resultContainer.hide();
    }

    function sendNotifications() {
        $.ajax({
            url: basePath + 'attendance/send-notifications',
            type: 'POST',
            data: {send_notification: true},
            error: function (jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            },
            beforeSend: function () {
            },
            success: function (response) {
                console.log('result', response);
            },
            complete: function () {
            },
        });
    }

    function searchAttendanceRecords() {
        var error = 0;

        if (userTypeInput.val() == '') {
            userTypeInput.addClass('errorBd');
            error++;
        }

        if (error == 0) {
            $('#filterForm').submit();
        }
    }

    function resetArForm() {
        userTypeInput.val('');
        levelInput.val('');
        sectionInput.val('');
        dateInput.val('');
        window.location = window.location.pathname + '?p=attendance-records';
    }

    function downloadReport() {
        var data = [];
        var tableHeader = $('#attendanceRecordTable thead th');
        var tableBody = $('#attendanceRecordTable tbody tr');
        var headers = [];

        var level = $('#level').val() == '' ? '' : $('#level option:selected').text().trim();
        var section = $('#section').val() == '' ? '' : $('#section option:selected').text().trim();
        var user_type = $('#userType option:selected').text().trim();
        var title = user_type == 'All' ? 'all types' : user_type;
        var info = {
            title: 'Attendance Report',
            subject: 'Record for ' + title,
            user_type: user_type,
            level: level,
            section: section,
            date_value: $('#dateValue').val()
        };


        $.each(tableHeader, function (i, e) {
            headers.push($(e).text());
        });
        data.push(headers);

        $.each(tableBody, function (x, y) {
            var row = oTable.row(y).data();
            data.push(row)
        });

        $('#attendanceReportData').val(JSON.stringify(data));
        $('#attendanceReportDescription').val(JSON.stringify(info));
        $('#downloadReportForm').submit();
    }

    function accessDenied(param) {
        $.ajax({
            url: basePath + 'attendance/access-denied',
            type: 'POST',
            data: {data: param},
            error: function (jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            },
            beforeSend: function () {
            },
            success: function (response) {
                console.log('result', response);
            },
            complete: function () {
            },
        });
    }

    function init() {
        if (current_controller != "undefined" && current_controller != 'Attendance') return;
        $('#userSelector').on('change', onUserSelect);
        $('#userSearch').on('change', onUserSearch);
        // $('#userSearch').on('keyup', onUserSearch);
        $('.start-search-manual').off('click').on('click', function (e) {
            e.preventDefault();
            $('#userSearch').trigger('change');
            isManual = 1;
        });
        $('#resetArForm').on('click', resetArForm);
        $('#btn-refresh').on('click', function () {
            location.reload()
        });

        // attendance records table
        $('#attendanceSearchBtn').on('click', searchAttendanceRecords);
        $('#downloadExcel').on('click', downloadReport);
        userTypeInput.on('change', onUserTypeChange);
        levelInput.on('change', onLevelChange);

        if (typeof user_type != 'undefined') {
            if (user_type == '') userTypeInput.eq(0).prop('selected', true);
            else userTypeInput.val(user_type);
        }

        // if (typeof level != 'undefined') {
        //     if (level == '') {
        //         levelInput.eq(0).prop('selected', true);
        //         sectionInput.prop('disabled', true);
        //     } else {
        //         levelInput.val(level);
        //         sectionInput.prop('disabled', false);
        //     }
        // }
        //
        // if (typeof section != 'undefined') {
        //     sectionInput.val(section);
        //     if (section == '') sectionInput.eq(0).prop('selected', true);
        // }
        //
        // if (typeof range != 'undefined') {
        //
        //     if (range == '') {
        //         $('#daterange-btn span').text('Select Date');
        //         dateInput.val('');
        //     } else {
        //         dateInput.val(range);
        //         $('#daterange-btn span').text(range);
        //     }
        // }

        oTable = $('#attendanceRecordTable').DataTable({
            "paging": true,
            "lengthChange": true,
            "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "columns": [
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                null,
            ],
            "language": {
                "emptyTable": "No Results Found."
            },
            "order": [[4, "desc"], [5, "desc"]]
        });
    }

    $(document).ready(init);

}(jQuery));