(function ($) {

    function onAccountDisable(e) {
        e.preventDefault();
        var button = $(this);
        var id = $(this).closest('tr').attr('data-id');
        var status = $(this).attr('data-status');
        var newStatus;
        var newClass;
        var oldClass;
        var newIcon;
        var oldIcon;
        var label;

        if (status == 0) {
            newStatus = 1;
            // newClass = 'btn-warning';
            // oldClass = 'btn-danger';
            newIcon = 'fa-check';
            oldIcon = 'fa-ban';
            label = 'Enable Account';

        } else {
            newStatus = 0;
            // newClass = 'btn-danger';
            // oldClass = 'btn-warning';
            newIcon = 'fa-ban';
            oldIcon = 'fa-check';
            label = 'Disable Account'
        }

        var data = {
            disable: true,
            id: id,
            status: newStatus,
        };

        if (id) {
            $.ajax({
                type: "POST",
                url: basePath + 'accounts/change-account-status',
                data: data,
                beforeSend: function () {
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                complete: function () {
                },
                success: function (response) {


                    if (response.status == 1) {
                        button.text('');
                        // button.prepend('<i class="fa ' + newIcon + '"></i> ' + label);
                        // button.removeClass(oldClass).addClass(newClass);

                        button.prepend(label);
                        button.attr('data-status', newStatus);
                        if (newStatus == 1) button.closest('tr').addClass('disabled');
                        else button.closest('tr').removeClass('disabled');

                        notifyMe({
                            title: 'Success!',
                            msg: response.msg,
                            type: 'success',
                            delay: 5000,
                        });
                    } else {
                        notifyMe({
                            title: 'Error!',
                            msg: response.msg,
                            type: 'danger',
                            delay: 5000,
                        });
                    }
                },
            });
        }
    }

    function onAccountResetPassword(e) {
        e.preventDefault();
        var id = $(this).closest('tr').attr('data-id');
        var full_name = $(this).closest('tr').find('.td-full-name').text().trim();
        var user_id = $(this).closest('tr').find('.td-generated-id').text().trim();

        if (id) {
            $.ajax({
                type: "POST",
                url: basePath + 'accounts/reset-password',
                data: {id: id, full_name: full_name, user_id: user_id},
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    if (response.status == 1) {
                        notifyMe({
                            title: 'Success!',
                            msg: response.msg,
                            type: 'success',
                            delay: 5000,
                        });
                    } else {
                        notifyMe({
                            title: 'Error!',
                            msg: response.msg,
                            type: 'danger',
                            delay: 5000,
                        });
                    }
                },
            });
        }
    }

    function showTempKey(e) {
        e.preventDefault();
        var tempKey = $(this).attr('data-key');
        $('#pTempKey').html('Temporary Key: <strong>' + tempKey + '</strong>');
        $('#tempKeyModal').modal();
    }

    function init() {
        if (typeof current_controller != "undefined" && current_controller != 'Accounts') return;

        $('.btn-disable-account').on('click', onAccountDisable);
        $('.btn-reset-pw').on('click', onAccountResetPassword);
        $('.tempKey').on('click', showTempKey);

        $('#userListFilter').find('select').change(function () {
            $('#userListFilter').submit();
        });

        $('#userTable').DataTable({
            "processing": true,
            "paging": true,
            "lengthChange": true,
            "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "columns": [
                null,
                null,
                null,
                null,
                null,
                null,
                {"orderable": false},
                {"orderable": false},
            ],
            "language": {
                "emptyTable": "No Results Found.",
                "processing": "<img src='img/double_ring.gif'> Loading...",
            },
            "order": [[0, "desc"]],
            "initComplete": function (settings, json) {
                // show table and hide loader
                $('#accountsLoader').hide();
                $('#accountList').show();
            }
        });


    }

    $(document).ready(init);
})(jQuery);