// Include gulp
var gulp = require('gulp');

// Include Our Plugins
var jshint = require('gulp-jshint');
var sass = require('gulp-sass');
var ignoreErrors = require('gulp-ignore-errors');
var concat = require('gulp-concat');
var uglify = require('gulp-uglify');
var rename = require('gulp-rename');
var cleanCss = require('gulp-clean-css');
var imagemin = require('gulp-imagemin');
var autoprefixer = require('gulp-autoprefixer');

var paths = {
    styles: {
        src: ['src/scss/*.scss', 'src/scss/**/*.scss'],
        dest: 'dist/css/'
    },
    scripts: {
        src: ['src/js/*.js', 'src/js/**/*.js'],
        dest: 'dist/js'
    },
    choose_db_scripts: {
        src: ['src/choose-db/js/*.js'],
        dest: 'dist/js',
    }
};

function styles() {
    return gulp
        .src(paths.styles.src, {
            sourcemaps: true
        })
        .pipe(sass({outputStyle: 'compressed'}).on('error', sass.logError))
        .pipe(autoprefixer())
        .pipe(rename({
            basename: 'style',
            suffix: '.min'
        }))
        .pipe(gulp.dest(paths.styles.dest));
}

function lint() {
    return gulp.src('src/js/*.js')
        .pipe(jshint())
        .pipe(jshint.reporter('default'));
}

function scripts() {
    return gulp
        .src(paths.scripts.src, {
            sourcemaps: true
        })
        .pipe(concat('all.min.js'))
        .pipe(uglify())
        .pipe(gulp.dest(paths.scripts.dest));
}

function basicScripts() {
    return gulp
        .src(paths.choose_db_scripts.src, {
            sourcemaps: true
        })
        .pipe(concat('custom.min.js'))
        .pipe(uglify())
        .pipe(gulp.dest(paths.choose_db_scripts.dest));
}

function watch() {
    gulp.watch(paths.scripts.src, {usePolling: true}, lint);
    gulp.watch(paths.scripts.src, {usePolling: true}, scripts);
    gulp.watch(paths.styles.src, {usePolling: true}, styles);
    gulp.watch(paths.choose_db_scripts.src, {usePolling: true}, basicScripts);
}

var build = gulp.parallel(styles, lint, scripts, basicScripts, watch);

gulp.task(build);
gulp.task('default', build);