<?php
if($role !== 'admin') {
    $url = 'dashboard.php?p=profile';
    header('location: '.$url);
}
$accounts = getData($con, SCHOOL_TBL, '1', 'name ASC');
$counter = 1;
?>
<section class="content-header">
    <h1>
        School Manager
        <small>This is where you manage the schools' accounts.</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="dashboard.php?p=profile"><i class="fa fa-dashboard"></i>Dashboard</a></li>
        <li class="active">Account Manager</li>
    </ol>
</section>
<section class="content">
    <div class="row">
        <div class="col-md-12">
            <?php if(isset($_SESSION['message']) AND $_SESSION['message'] != null): ?>
                <div class="alert alert-success alert-dismissable">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                    <strong>Success!</strong> <?php echo $_SESSION['message']; ?>
                </div>
                <?php unset($_SESSION['message']); ?>
            <?php endif; ?>
            <div class="alert alert-success alert-dismissable" id="ac-message" style="display: none">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <strong>Success!</strong> Access permission changed.
            </div>
            <div class="container-fluid no-padding mb-10">
                <a href="dashboard.php?p=account-form" class="btn btn-primary account-btn btn-sm"><i class="fa fa-plus mr-5"></i> Add New</a>
            </div>
            <div class="box box-default box-solid">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-accounts"></i> Account List</h3>
                </div>
                <div class="box-body">
                    <div class="table-responsive">
                        <table id="accountTable" class="table table-stripped table-hover dataTable">
                            <thead>
                            <th>Logo</th>
                            <th>Account ID</th>
                            <th>Name</th>
                            <th>Short Name</th>
                            <th>Email</th>
                            <th>Status</th>
                            <th>Temporary Key</th>
                            <th>Actions</th>
                            </thead>
                            <tbody>
                            <?php if(isset($accounts) AND count($accounts) > 0): ?>
                                <?php foreach ($accounts as $key => $value): ?>
                                    <tr data-id="<?php echo $value['id']; ?>">
                                        <td>
                                            <div class="school-logo-cont">
                                                <img class="thumbnail" src="<?php echo !empty($value['picture']) ? $uploadUrl.'/schools/'.$value['picture'] : 'assets/images/default_image_01.png'; ?>">
                                            </div>
                                        </td>
                                        <td><?php echo $value['account_id']; ?></td>
                                        <td id="tdFullName">
                                            <?php echo $value['name']; ?>
                                        </td>
                                        <td>
                                            <?php echo $value['short_name']; ?>
                                        </td>
                                        <td>
                                            <?php echo !empty($value['email']) ? $value['email'] : '--'; ?>
                                        </td>
                                        <td>
                                            <?php echo $value['temp_key'] == '' ? 'Active' : 'Pending'; ?>
                                        </td>
                                        <td>
                                            <?php if(empty($value['temp_key'])): ?>
                                                <i class="fa fa-ban text-muted"></i>
                                            <?php else: ?>
                                                <a class="text-warning tempKey" href="#" data-key="<?php echo $value['temp_key']; ?>"> <i class="fa fa-key"></i></a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="big-sc-btn">
                                                <a class="btn btn-success btn-sm btn-flat" href="dashboard.php?p=account-form&id=<?php echo $value['id']; ?>"><i class="fa fa-pencil"></i> EDIT</a>
                                                <?php if($value['account_close'] == 0): ?>
                                                    <a class="btn btn-danger btn-sm btn-flat btn-disable-account" href="#" data-status="<?php echo $value['account_close']; ?>"><i class="fa fa-ban"></i> DISABLE</a>
                                                <?php else: ?>
                                                    <a class="btn btn-warning btn-sm btn-flat btn-disable-account" href="#" data-status="<?php echo $value['account_close']; ?>"><i class="fa fa-check"></i> ENABLE</a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="box-footer">
                </div>
            </div>
        </div>
    </div>
</section>
<!-- temp key modal -->
<div id="tempKeyModal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-sm">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Accounts' Temporary Key</h4>
            </div>
            <div class="modal-body">
                <p id="pTempKey"></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>

    </div>
</div>
