<?php
$currentProfile = [];
$profileId = '';
if(isset($_GET['id'])) {
    $profileId = $_GET['id'];
    $profile = getData($con, ACCOUNTS_TBL, 'id = '.$profileId);

    if(count($profile)) $currentProfile = current($profile);
}
?>
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>
        Profile <?php echo $profileId !== '' ? 'Edit' : 'Add'; ?> Form
        <small>This is where you manage a profile.</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="dashboard.php?p=profile"><i class="fa fa-dashboard"></i>Dashboard</a></li>
        <li class="active">Users</li>
        <li class="active">Profile Form</li>
    </ol>
</section>
<section class="content">
    <div class="row">
        <div class="col-md-8 col-md-offset-2 col-sm-12">
            <div class="box box-solid box-default">
                <div class="box-header">
                    <h3 class="box-title">Form</h3>
                    <div id="errorBox" class="alert alert-danger alert-dismissable" style="display: none">
                        <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                        <p id="errorRequired" style="display: none">* Fill the required fields.</p>
                        <p id="errorEmailExist" style="display: none">* Email is in use.</p>
                        <p id="errorIdExist" style="display: none">* ID number is in use.</p>
                    </div>
                </div>
                <div class="box-body pd-20">
                    <form id="profile-form" method="post" action="functions/profileManager.php" class="mt-10">
                        <input class="hidden" name="form" value="profile-form">
                        <input class="hidden" name="currentUser" value="<?php echo $currentUser['id']; ?>">
                        <input class="hidden" name="id" id="profileId" value="<?php echo isset($profileId) ? $profileId : ''; ?>">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="img-container">
                                    <a class="edit-img-btn" href="#" data-toggle="tooltip" title="Change image"><i class="fa fa-pencil-square-o fa-2x text-info"></i></a>
                                    <img id="user-pp" class="profile-form-img img-responsive" src="<?php echo isset($currentProfile['picture']) ? $uploadUrl.'/users/'.$currentProfile['picture'] : 'assets/images/default_image_01.png'; ?>" alt="User profile picture">
                                    <input class="hidden" name="img-src" id="img-src" value="">
                                    <input class="hidden" name="file-name" id="file-name" value="<?php echo isset($currentProfile['picture']) ? $currentProfile['picture'] : '' ; ?>">
                                    <input class="hidden" name="is-upload" id="isUpload" value="0">
                                    <input class="hidden" type="file" id="upload-user-pp">
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="first-name">First Name</label>
                                    <input type="text" name="first-name" class="form-control req" placeholder="Enter first name.." value="<?php echo isset($currentProfile['first_name']) ? $currentProfile['first_name'] : ''; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="middle-name">Middle Name</label>
                                    <input type="text" name="middle-name" class="form-control" placeholder="Enter middle name.." value="<?php echo isset($currentProfile['middle_name']) ? $currentProfile['middle_name'] : ''; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="last-name">Last Name</label>
                                    <input type="text" name="last-name" class="form-control req" placeholder="Enter last name.." value="<?php echo isset($currentProfile['last_name']) ? $currentProfile['last_name'] : ''; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="role">Role</label>
                                    <select name="role" class="form-control">
                                        <option value="0" class="text-muted">Guest</option>
                                        <?php if (isset($currentProfile['role']) && $currentProfile['role'] == 'a'): ?>
                                            <option value="a" <?php echo isset($currentProfile['role']) && $currentProfile['role'] == 'a' ? 'selected' : ''; ?>>Developer</option>
                                        <?php endif; ?>
                                        <option value="1" <?php echo isset($currentProfile['role']) && $currentProfile['role'] == 1 ? 'selected' : ''; ?>>Admin</option>
                                        <option value="2" <?php echo isset($currentProfile['role']) && $currentProfile['role'] == 2 ? 'selected' : ''; ?>>Manager</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="card-id">Card ID</label>
                                    <input type="text" name="card-id" class="form-control" placeholder="Enter Card ID number.." value="<?php echo isset($currentProfile['card_id']) ? $currentProfile['card_id'] : ''; ?>">
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="email">Email</label>
                                    <input type="text" name="email" class="form-control req" placeholder="Enter email.." value="<?php echo isset($currentProfile['email']) ? $currentProfile['email'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="address">Address</label>
                                    <input type="text" name="address" class="form-control" placeholder="Enter address.." value="<?php echo isset($currentProfile['address']) ? $currentProfile['address'] : ''; ?>">
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="barangay">Barangay</label>
                                    <input type="text" name="barangay" class="form-control" placeholder="Enter barangay.." value="<?php echo isset($currentProfile['barangay']) ? $currentProfile['barangay'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="city">City/Municipality</label>
                                    <input type="text" name="city" class="form-control" placeholder="Enter city.." value="<?php echo isset($currentProfile['city']) ? $currentProfile['city'] : ''; ?>">
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="province">Province</label>
                                    <input type="text" name="province" class="form-control" placeholder="Enter province.." value="<?php echo isset($currentProfile['province']) ? $currentProfile['province'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="postal">Postal</label>
                                    <input type="text" name="postal" class="form-control" placeholder="Enter postal.." value="<?php echo isset($currentProfile['postal']) ? $currentProfile['postal'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="mobile">Mobile Number</label>
                                    <input type="text" name="mobile" class="form-control" maxlength="10" placeholder="Enter 10 Digit Mobile number.." value="<?php echo isset($currentProfile['mobile_number']) ? $currentProfile['mobile_number'] : ''; ?>">
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="phone">Telephone</label>
                                    <input type="text" name="phone" class="form-control" placeholder="Enter Telephone number.." value="<?php echo isset($currentProfile['telephone_number']) ? $currentProfile['telephone_number'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="text-center">
                            <button id="saveProfile" type="button" class="btn btn-primary"><i class="fa fa-save"></i> Save Profile</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>