<?php
$currentPartner = [];
$partnerId = '';
if(isset($_GET['id'])) {
    $partnerId = $_GET['id'];
    $profile = getData($con, PARTNER_TBL, 'id = '.$partnerId);

    if(count($profile)) $currentPartner = current($profile);
}
?>
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>
        Partner Form
        <small>This is where you manage a partner account.</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="dashboard.php?p=profile"><i class="fa fa-dashboard"></i>Dashboard</a></li>
        <li class="active"><a href="dashboard.php?p=partners">Partners</a></li>
        <li class="active">Form</li>
    </ol>
</section>
<section class="content">
    <div class="row">
        <div class="col-md-8 col-md-offset-2 col-sm-12">
            <div class="box box-solid box-default">
                <div class="box-header with-border">
                    <h3 class="box-title"><?php echo $partnerId !== '' ? 'Edit' : 'Add Partner'; ?></h3>
                </div>
                <div class="box-body pd-20">
                    <div id="errorBox" class="alert alert-danger alert-dismissable" style="display: none">
                        <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                        <p id="errorRequired" style="display: none">* Fill the required fields.</p>
                        <p id="errorEmailExist" style="display: none">* Email is in use.</p>
                        <p id="errorIdExist" style="display: none">* ID number is in use.</p>
                    </div>
                    <form id="partner-form" method="post" action="functions/partnerManager.php">
                        <input class="hidden" name="form" value="partner-form">
                        <input class="hidden" name="currentUser" value="<?php echo $currentUser['id']; ?>">
                        <input class="hidden" name="partner-id" id="partnerId" value="<?php echo isset($partnerId) ? $partnerId : ''; ?>">
                        <input class="hidden" name="partner-account-id" id="partnerAccountId" value="<?php echo isset($currentPartner['account_id']) ? $currentPartner['account_id'] : '' ; ?>">
                        <div class="row">
                            <div class="col-md-6 col-sm-12 text-center mb-10">
                                <div class="img-container">
                                    <a class="edit-img-btn" href="#" data-toggle="tooltip" title="Change image"><i class="fa fa-pencil-square-o fa-2x text-info"></i></a>
                                    <img id="account-picture" width="200px" class="profile-form-img img-responsive form-img" src="<?php echo isset($currentPartner['photo']) && $currentPartner['photo'] != '' ? $uploadUrl.'/partners/'.$currentPartner['account_id'].'/'.$currentPartner['photo'] : 'assets/images/default_image_01.png'; ?>" alt="Partner Logo" style="margin: 0 auto">
                                    <input class="hidden" name="img-src" id="img-src" value="">
                                    <input class="hidden" name="file-name" id="file-name" value="<?php echo isset($currentPartner['photo']) ? $currentPartner['photo'] : '' ; ?>">
                                    <input class="hidden" name="is-upload" id="isUpload" value="0">
                                    <input class="hidden" type="file" id="upload-account-picture">
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="partner-name">Company Name</label>
                                    <input type="text" name="partner-name" class="form-control req" placeholder="* Enter name.." value="<?php echo isset($currentPartner['company_name']) ? $currentPartner['company_name'] : ''; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="partner-address">Address</label>
                                    <textarea name="partner-address" class="form-control req" placeholder="* Enter address.."><?php echo isset($currentPartner['address']) ? $currentPartner['address'] : ''; ?></textarea>
                                </div>
                                <div class="form-group">
                                    <label for="partner-email">Email</label>
                                    <input type="email" name="partner-email" class="form-control req" placeholder="* Enter email.." value="<?php echo isset($currentPartner['email']) ? $currentPartner['email'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="partner-contact-number">Contact Number</label>
                                    <input type="text" name="partner-contact-number" class="form-control req" placeholder="* Enter contact number.." value="<?php echo isset($currentPartner['contact_number']) ? $currentPartner['contact_number'] : ''; ?>">
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="partner-contact-person">Contact Person</label>
                                    <input type="text" name="partner-contact-person" class="form-control req" placeholder="* Enter contact person.." value="<?php echo isset($currentPartner['contact_person']) ? $currentPartner['contact_person'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="city">Type</label>
                                    <select name="partner-type" class="form-control req partner-type-select">
                                        <option value="0">-- Select --</option>
                                        <option value="1" <?php echo isset($currentPartner['type']) && $currentPartner['type'] == 1 ? 'selected' : ''; ?>>Premium</option>
                                        <option value="2" <?php echo isset($currentPartner['type']) && $currentPartner['type'] == 2 ? 'selected' : ''; ?>>Basic</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="text-center Enter">
                            <button id="savePartner" type="button" class="btn btn-primary"><i class="fa fa-save"></i> Save Partner</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>