<?php
$ads = [];
$where = '1';
if($_SESSION['user_role'] == 3) {
   $where = 'a.partner_id = '.$_SESSION['user_id'];
}
$ads = customQuery($con,
        "SELECT
            a.*,
            p.company_name,
            p.account_id as pid
        FROM
            partners_ads_tbl as a
        LEFT JOIN
            partners_tbl as p ON p.id = a.partner_id
        WHERE $where
        "
);
?>
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>
        Partner Ads List
        <small>This is where you manage a partners' ads.</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="dashboard.php?p=profile"><i class="fa fa-dashboard"></i>Dashboard</a></li>
        <li class="active"><a href="dashboard.php?p=partners">Partners</a></li>
        <li class="active">Partner Ads</li>
    </ol>
</section>
<section class="content">
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <?php if(isset($_SESSION['message']) AND $_SESSION['message'] != null): ?>
                <div class="alert alert-success alert-dismissable">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                    <strong>Success!</strong> <?php echo $_SESSION['message']; ?>
                </div>
                <?php unset($_SESSION['message']); ?>
            <?php endif; ?>
            <div class="alert alert-success alert-dismissable" id="adPubMsg" style="display: none">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <strong>Success!</strong> Status Updated.
            </div>
            <div class="container-fluid no-padding mb-10">
                <a href="dashboard.php?p=partner-ad-form" class="btn btn-primary account-btn btn-sm"><i class="fa fa-plus mr-5"></i> Add New</a>
            </div>
            <div class="box box-solid box-default">
                <div class="box-header">
                    <h3 class="box-title">Ads Registered</h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-6 col-sm-6 col-xs-12">
                            <small class="help-block"><i class="fa fa-info-circle mr-5"></i>Click on the banner image to see full version.</small>
                        </div>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                            <span class="pull-right">
                                <span class="text-bold text-info">Legend:</span>
                                <i class="fa fa-eye text-success mr-5"></i>Published |
                                <i class="fa fa-eye-slash text-danger mr-5"></i>Unpublished
                            </span>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table id="partnerAdsTable" class="table table-hover table-striped">
                            <thead>
                            <th>Status</th>
                            <th>Banner</th>
                            <th>Company</th>
                            <th>Ad ID</th>
                            <th>Title</th>
                            <th>Description</th>
                            <th>Duration</th>
                            <th>Date Created</th>
                            <th>Actions</th>
                            </thead>
                            <tbody>
                            <?php if(isset($ads) AND count($ads) > 0): ?>
                                <?php foreach ($ads as $key => $ad): ?>
                                    <tr data-id="<?php echo $ad['id']; ?>">
                                        <td class="text-center" style="vert-align: middle">
                                            <?php if($ad['is_publish']): ?>
                                                <a href="#" class="text-black publish-ad-btn" data-pub="1">
                                                    <i class="fa fa-eye fa-lg"></i>
                                                </a>
                                            <?php else: ?>
                                                <a href="#" class="text-black publish-ad-btn" data-pub="0">
                                                    <i class="fa fa-eye-slash fa-lg"></i>
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($ad['photo'] != ''): ?>
                                                <a href="<?php echo  $uploadUrl."/partners/".$ad['pid']."/ads/".$ad['photo']; ?>" style="cursor: zoom-out" class="viewAdBanner">
                                                    <img width="50px" src="<?php echo  $uploadUrl."/partners/".$ad['pid']."/ads/".$ad['photo']; ?>">
                                                </a>
                                            <?php else: ?>
                                                <i class="fa fa-photo fa-2x text-muted"></i>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo $ad['company_name']; ?></td>
                                        <td><?php echo $ad['ad_id']; ?></td>
                                        <td class="ws-normal"><?php echo $ad['title']; ?></td>
                                        <td class="ws-normal"><?php echo $ad['description']; ?></td>
                                        <td><?php echo $ad['duration']; ?></td>
                                        <td><?php echo date('m-d-Y', strtotime($ad['date_created'])); ?></td>
                                        <td>
                                            <a class="btn btn-warning btn-flat btn-sm" href="dashboard.php?p=partner-ad-form&id=<?php echo $ad['id']; ?>"><i class="fa fa-pencil mr-5"></i>Edit</a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>