<?php
$currentPartnerAd = [];
$targets = [];
$targetId = [];
$partnerAdId = '';
if (isset($_GET['id'])) {
    $partnerAdId = $_GET['id'];
    $partnerAd = customQuery($con,
        "SELECT
            a.*,
            p.id as pid,
            p.company_name,
            p.account_id as p_aid 
        FROM
            partners_ads_tbl as a
        LEFT JOIN
            partners_tbl as p ON p.id = a.partner_id
        WHERE
            a.id = $partnerAdId        
        "
    );

    if (count($partnerAd))
        $currentPartnerAd = current($partnerAd);

    $getTargets = customQuery($con,
        "SELECT 
            m.*,
            s.name
        FROM 
            `partners_ad_target_map` as m 
        LEFT JOIN
            school_tbl as s on m.school_id = s.id
         WHERE
            m.ad_id = $partnerAdId
        ORDER BY m.school_id DESC    
    ");

    if(count($getTargets)) {
        $targetAudience = [];
        foreach ($getTargets as $t => $target) {
            $targetAudience[$t]['id'] = $target['ad_id'];
            $targetAudience[$t]['text'] = $target['name'];
            $targetId[] = $target['school_id'];
        }

        $targets = json_encode($targetAudience);
    }
}

$partners = getData($con, PARTNER_TBL, '1', 'company_name ASC');
$schools = customQuery($con, "SELECT id, name FROM school_tbl WHERE account_close = 0");
?>
<script>
    var targets = '<?php echo $targets; ?>';
    var targetId = '<?php echo implode(',', $targetId); ?>';
</script>
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>
        Partner Ads Form
        <small>This is where you manage a partners' ads information.</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="dashboard.php?p=profile"><i class="fa fa-dashboard"></i>Dashboard</a></li>
        <li class="active"><a href="dashboard.php?p=partner-ads">Ads</a></li>
        <li class="active">Form</li>
    </ol>
</section>
<section class="content">
    <div class="row">
        <div class="col-md-8 col-md-offset-2 col-sm-12">
            <div class="box box-solid box-default">
                <div class="box-header with-border">
                    <h3 class="box-title"><?php echo $partnerAdId !== '' ? 'Edit Advertisement' : 'Add Advertisement'; ?></h3>
                </div>
                <div class="box-body pd-20">
                    <div id="errorBox" class="alert alert-danger alert-dismissable" style="display: none">
                        <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                        <p id="errorRequired" style="display: none">Fill the required fields.</p>
                        <p id="errorPhoto" style="display: none">Please upload the ad banner.</p>
                        <p id="errorAdDesc" style="display: none">You have exceeded the maximum characters allowed.</p>
                        <p id="errorAdUrl" style="display: none">Please provide a valid link.</p>
                        <p id="errorDimension">Image size should be 728x90 px only.</p>
                        <p id="errorMime">Image should be (jpeg, jpg, png, gif) only.</p>
                    </div>
                    <div id="successBox" class="alert alert-success alert-dismissable" style="display: none">
                        <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                        <strong>Succes!</strong><span class="s-msg ml-5"></span>
                    </div>
                    <form id="partner-ad-form" method="post" action="functions/partnerManager.php">
                        <input class="hidden" name="form" value="partner-ad-form">
                        <input class="hidden" name="currentUser" value="<?php echo $currentUser['id']; ?>">
                        <input class="hidden" name="partner-ad-id" id="partnerAdId"
                               value="<?php echo isset($partnerAdId) ? $partnerAdId : ''; ?>">
                        <div class="row">
                            <label for="" class="ml-15 mb-0">Banner
                                <small class="text-muted it">(format: jpeg, jpg, png - size: 728x90px)</small>
                            </label>
                            <div class="col-md-12 col-sm-12 text-center">
                                <div class="ad-img-container">
                                    <a class="edit-ad-img-btn" href="#" data-toggle="tooltip" title="Change image"><i
                                                class="fa fa-pencil-square-o fa-2x text-info"></i></a>
                                    <img id="ad-picture" class="ad-img img-responsive form-img"
                                         data-is-placeholder="<?php echo isset($currentPartnerAd['photo']) && $currentPartnerAd['photo'] != '' ? 0 : 1; ?>"
                                         src="<?php echo isset($currentPartnerAd['photo']) && $currentPartnerAd['photo'] != '' ? $uploadUrl . '/partners/' . $currentPartnerAd['p_aid'] . '/ads/' . $currentPartnerAd['photo'] : 'assets/images/728x90.png'; ?>"
                                         alt="ad banner">
                                    <input class="hidden" name="img-src" id="img-src" value="">
                                    <input class="hidden" name="file-name" id="file-name"
                                           value="<?php echo isset($currentPartnerAd['photo']) ? $currentPartnerAd['photo'] : ''; ?>">
                                    <input class="hidden" name="is-upload" id="isUpload" value="0">
                                    <input class="hidden" type="file" id="upload-account-picture">
                                </div>
                            </div>
                        </div>
                        <div class="row mt-10">
                            <div class="col-md-12 col-sm-12">
                                <div class="form-group">
                                    <label for="partner-name">Partner</label>
                                    <select name="partner-name" class="form-control req" id="partnerName">
                                        <option value="" class="text-muted">-- SELECT --</option>
                                        <?php if (count($partners) > 0): ?>
                                            <?php foreach ($partners as $key => $value): ?>
                                                <option value="<?php echo $value['id']; ?>" <?php echo isset($currentPartnerAd['pid']) && $currentPartnerAd['pid'] == $value['id'] ? 'selected' : ''; ?>><?php echo $value['company_name']; ?></option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 col-sm-12">
                                <div class="form-group">
                                    <label for="partner-ad-title">Title</label>
                                    <input type="text" name="partner-ad-title" id="padTitle" class="form-control req"
                                           placeholder="* Enter ad title.."
                                           value="<?php echo isset($currentPartnerAd['title']) ? $currentPartnerAd['title'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 col-sm-12">
                                <div class="form-group">
                                    <label for="partner-ad-desc">Description
                                        <small class="text-muted it">(450 characters only)</small>
                                    </label>
                                    <textarea name="partner-ad-desc" id="padDesc" class="form-control req"
                                              placeholder="* Enter ad description.."><?php echo isset($currentPartnerAd['description']) ? $currentPartnerAd['description'] : ''; ?></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 col-sm-12">
                                <div class="form-group">
                                    <label for="partner-ad-url">URL</label>
                                    <input type="text" name="partner-ad-url" id="padUrl" class="form-control"
                                           placeholder="* Enter ad url for redirection.."
                                           value="<?php echo isset($currentPartnerAd['url']) ? $currentPartnerAd['url'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Target Audience</label>
                                    <select class="form-control select2 select2-hidden-accessible" multiple=""
                                            data-placeholder="Select a target audience" style="width: 100%;" tabindex="-1"
                                            aria-hidden="true" id="adAudience">
                                        <?php if (count($schools)): ?>
                                            <?php foreach ($schools as $school): ?>
                                                <option value="<?php echo $school['id']; ?>"
                                                    <?php count($targetId) && in_array($school['id'], $targetId) ? 'selected' : ''; ?>>
                                                    <?php echo $school['name']; ?></option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 col-sm-12">
                                <div class="form-group">
                                    <label>Duration
                                        <small class="text-muted">(date range)</small>
                                    </label>
                                    <div class="input-group">
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </div>
                                        <input class="form-control pull-right req" name="partner-ad-duration"
                                               type="text" id="padDuration"
                                               value="<?php echo isset($currentPartnerAd['duration']) ? $currentPartnerAd['duration'] : ''; ?>">
                                    </div>
                                    <!-- /.input group -->
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <label class="ml-15">Ad Type</label>
                            <small class="help-block ml-15 mt-0"><i
                                        class="fa fa-info-circle"></i> If you choose the text, ads will display on a plain background on target pages. If you choose banner leave title and description with "N/A" as values.
                            </small>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <div class="radio mt-0">
                                        <label>
                                            <input type="radio" class="ad-type" name="ad-type-options" id="adOption1" value="0"
                                                   <?php echo isset($currentPartnerAd['is_banner']) && !$currentPartnerAd['is_banner'] ? 'checked' : ''; ?>>
                                            Text Ad
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <div class="radio mt-0">
                                        <label>
                                            <input type="radio" class="ad-type" name="ad-type-options" id="adOption2" value="1"
                                            <?php echo isset($currentPartnerAd['is_banner']) && $currentPartnerAd['is_banner'] ? 'checked' : ''; ?>>
                                            Banner Ad
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="text-center Enter">
                            <button id="savePartnerAd" type="button" class="btn btn-primary"><i
                                        class="fa fa-save"></i> Save Ad
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>