<?php
session_start();
include '../config/main.config.php';
include '../config/database.config.php';
include '../../tools/passwordGenerator.php';
include '../../tools/imageManager.php';
include '../../tools/dataManager.php';
include '../../tools/validator.php';
include '../../classes/NotificationManager.php';

/** @var  $notificationManager */
$notificationManager = new NotificationManager();

/** disable accounts */
if (isset($_POST['disable'])) {
    $userId = $_POST['id'];
    $userStatus = $_POST['status'];

    $toUpdate = array('account_close' => $userStatus);
    $update = updateData($con, ACCOUNTS_TBL, $toUpdate, 'id = ' . $userId);
    if ($update)
        echo json_encode(array('status' => 'success', 'id' => $userId));
}

/** save profile */
if (isset($_POST['form'])) {

    //get all the post data and test the inputs for html special characters, white spaces and slashes
    $id = $_POST['id'];
    $cardId = $_POST['card-id'] != '' ? $_POST['card-id'] : NULL;
    $role = test_input($_POST['role']);
    $img_src = $_POST['img-src'];
    $first_name = test_input($_POST['first-name']);
    $middle_name = test_input($_POST['middle-name']);
    $last_name = test_input($_POST['last-name']);
    $email = isset($_POST['email']) ? test_input($_POST['email']) : NULL;
    $address = test_input($_POST['address']);
    $barangay = test_input($_POST['barangay']);
    $city = test_input($_POST['city']);
    $province = test_input($_POST['province']);
    $postal = empty($_POST['postal']) ? NULL : test_input($_POST['postal']);
    $mobile = test_input($_POST['mobile']);
    $phone = test_input($_POST['phone']);
    $imgName = $_POST['file-name'];
    $imgSource = $_POST['img-src'];
    $isUpload = $_POST['is-upload'];
    $picture = $imgName;

    //generate password for the user
    $tempKey = generateStrongPassword(8, false, 'luds');
    $hash = password_hash($tempKey, PASSWORD_BCRYPT);

    $token = password_hash($email, PASSWORD_BCRYPT);


    if ($isUpload) {
        $saveImage = saveBase64Image($imgSource, $imgName, $static . '/users');
        if ($saveImage)
            $picture = $saveImage['filename'];
    }

    // generated User ID
    $getUsers = getData($con, ACCOUNTS_TBL);
    $count = count($getUsers);
    $counter = $count == 0 ? 1 : $count + 1;
    $counter = $counter < 10 ? '0' . $counter : $counter;
    $userId = 'admin' . $counter;

    $userInfo = array(
        'user_id' => $userId,
        'card_id' => $cardId,
        'password' => $hash,
        'email' => $email,
        'picture' => $picture,
        'first_name' => $first_name,
        'middle_name' => $middle_name,
        'last_name' => $last_name,
        'address' => $address,
        'city' => $city,
        'barangay' => $barangay,
        'province' => $province,
        'postal' => $postal,
        'mobile_number' => $mobile,
        'telephone_number' => $phone,
        'role' => $role,
        'temp_key' => $tempKey,
    );

    //update user information if there is an ID on post
    if (intval($id)) {
        unset($userInfo['password'], $userInfo['temp_key']);

        $update = updateData($con, ACCOUNTS_TBL, $userInfo, 'id = ' . $id);

        if ($update == 1) {
            $_SESSION['message'] = 'User profile updated.';
            header('location: ../dashboard.php?p=users');
        } else {
            echo $update;
        }
    } else { //create a new user
        $insert = createData($con, ACCOUNTS_TBL, $userInfo);
        if (intval($insert)) {
            $_SESSION['message'] = 'New user added.';
            header('location: ../dashboard.php?p=users');
        } else {
            echo $insert;
        }
    }
}

/**
 * script for resetting password
 */
if (isset($_POST['reset'])) {
    $id = $_POST['id'];
    $fullName = $_POST['fullName'];
    $sendEmail = '';

    if ($id) {
        $isUser = getData($con, ACCOUNTS_TBL, "id = $id");

        if (count($isUser)) {
            $emailList = ['jrwebapps@gmail.com',]; //admin email list 'contact@clairemontferrond.com'
            $random = generateStrongPassword(8, false, 'luds');
            $token = password_hash($random, PASSWORD_BCRYPT);

            updateData($con, ACCOUNTS_TBL, ['password' => $token, 'temp_key' => $random], 'id = ' . $id);

            $dateNow = date('m/d/Y h:i a');
            $subject = 'Comitatus Admin Reset Password';
            $body = "Hi <strong>Admin</strong>" .
                "<p>$fullName is requesting a new password.</p>" .
                "<p>This request was done on $dateNow</p>";

            foreach ($emailList as $email) {
                $sendEmail = $notificationManager->sendMail($email, $subject, $body);
            }

            echo json_encode($sendEmail);
            exit;
        }
    }
}

/** forget password */
if (isset($_POST['forget_password'])) {
    $email = test_input($_POST['email']);

    if (!empty($email)) {

        if (!count(validateEmail($email))) {
            $isUser = getData($con, ACCOUNTS_TBL, "email = '$email' AND account_close = 0");
            if (count($isUser)) {

                //generate password for the user
                $tempKey = generateStrongPassword(8, false, 'luds');
                $hash = password_hash($tempKey, PASSWORD_BCRYPT);
                updateData($con, ACCOUNTS_TBL, ['password' => $hash, 'temp_key' => $tempKey], "email = '$email' ");


                // send email
                $dateNow = date('m/d/Y h:i a');
                $subject = 'Comitatus Admin New Password';
                $body = "<p>Hello,</p>
                        <p>This is your new password: $tempKey</p><br>
                        <p>- Comitatus Admin</p>
                        ";

                $sendEmail = $notificationManager->sendMail($email, $subject, $body);

                echo json_encode(['status' => 1]);
            } else {
                echo json_encode(['status' => 0, 'msg' => 'Account not recognized.']);
                exit;
            }

        } else {
            echo json_encode(['status' => 0, 'msg' => 'Please input a valid email']);
            exit;
        }
    } else {
        echo json_encode(['status' => 0, 'msg' => 'Please input your email']);
        exit;
    }
}
