<?php
session_start();
include '../config/main.config.php';
include '../config/database.config.php';
include '../../tools/passwordGenerator.php';
include '../../tools/imageManager.php';
include '../../tools/dataManager.php';
include '../../tools/validator.php';
include '../../tools/FileTools.php';
include '../../classes/NotificationManager.php';

/**
 * redirect to profile page if someone tries to visit this page manually
 * access to this page should only be done via POST request
 */
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    $url = '../dashboard.php?p=profile';
    header('location: ' . $url);
}

$modifiedBy = $_SESSION['user_id'];
$dateNow = date('Y-m-d H:i:s');
$fileTools = new FileTools();

if (isset($_POST['form']) && $_POST['form'] == 'partner-form') {

    $id = $_POST['partner-id'];
    $accountId = $_POST['partner-account-id'];
    $name = test_input($_POST['partner-name']);
    $address = test_input($_POST['partner-address']);
    $email = isset($_POST['partner-email']) ? test_input($_POST['partner-email']) : NULL;
    $contactNum = $_POST['partner-contact-number'];
    $contactPerson = $_POST['partner-contact-person'];
    $imgName = $_POST['file-name'];
    $imgSource = $_POST['img-src'];
    $isUpload = $_POST['is-upload'];
    $type = $_POST['partner-type'] == 0 ? 2 : $_POST['partner-type'];

    //generate password for the user
    $tempKey = generateStrongPassword(8, false, 'luds');
    $hash = password_hash($tempKey, PASSWORD_BCRYPT);

    $partnerData = array(
        'type' => $type,
        'company_name' => $name,
        'address' => $address,
        'email' => $email,
        'contact_number' => $contactNum,
        'contact_person' => $contactPerson,
        'temp_key' => $tempKey,
        'password' => $hash,
        'date_created' => $dateNow,
        'modified_by' => $modifiedBy,
    );

    //update account information if there is an ID on post
    if (intval($id)) {
        unset($partnerData['temp_key'], $partnerData['password']);
        $update = updateData($con, PARTNER_TBL, $partnerData, "id = $id");
        if ($update == 1) {
            $_SESSION['message'] = 'Account Information updated.';
            header('location: ../dashboard.php?p=partners');
        } else {
            echo $update;
        }
    } else { //create a new account
        $existingPartners = getData($con, PARTNER_TBL);
        $count = count($existingPartners);
        $counter = $count == 0 ? 1 : $count + 1;
        $counter = $counter < 10 ? '0' . $counter : $counter;

        $accountId = 'P' . date('mY') . $counter;
        $partnerData['account_id'] = $accountId;

        $insert = createData($con, PARTNER_TBL, $partnerData);
        if (intval($insert)) {
            mkdir($static . '/partners/' . $accountId); // partner dir
            mkdir($static . '/partners/' . $accountId . '/ads'); // partner ads dir

            $_SESSION['message'] = 'New Account Added.';
            header('location: ../dashboard.php?p=partners');
        } else {
            echo $insert;
        }
    }

    if ($isUpload) {
        $ext = $fileTools->getFileExtension($imgName);
        $fileName = $accountId . '_logo.' . $ext;
        saveBase64Image($imgSource, $fileName, $static . '/partners/' . $accountId);
        updateData($con, PARTNER_TBL, ['photo' => $fileName], "id = $id");
    }

}

/** saving ad form */
if (isset($_POST['form']) && $_POST['form'] == 'partner-ad-form') {

    $id = $_POST['id'];
    $partnerId = $_POST['partner_name'];
    $title = test_input($_POST['title']);
    $description = test_input($_POST['description']);
    $url = test_input($_POST['url']);
    $duration = test_input($_POST['duration']);
    $adImgName = $_POST['file_name'];
    $adImgSource = $_POST['img_src'];
    $adIsUpload = $_POST['is_upload'];
    $isBanner = $_POST['is_banner'];
    $target = json_decode($_POST['target_audience']);
    $imgValidator = [];
    $adId = 'PA' . $partnerId . generateStrongPassword(4, false, 'lud');

    // validate image
    if ($adIsUpload) $imgValidator = validateImage($adImgSource, 728, 90, ['jpg', 'jpeg', 'png', 'gif']);

    if (count($imgValidator)) {
        echo json_encode(['status' => 'error', 'msg' => $imgValidator]);
    } else {
        $partnerAdData = array(
            'ad_id' => $adId,
            'partner_id' => $partnerId,
            'title' => $title,
            'description' => $description,
            'url' => $url,
            'duration' => $duration,
            'is_banner' => $isBanner,
            'is_publish' => 1,
            'date_created' => $dateNow,
            'modified_by' => $modifiedBy,
        );

        if (intval($id)) {
            unset($partnerAdData['ad_id']);
            $update = updateData($con, PARTNER_ADS_TBL, $partnerAdData, "id = $id");
            if ($update == 1) {
                echo json_encode(['status' => 'success', 'msg' => 'Advertisement updated.']);
            } else {
                echo $update;
            }
        } else { //create a new ad
            $insert = createData($con, PARTNER_ADS_TBL, $partnerAdData);
            if (intval($insert)) {
                $id = $insert;
                echo json_encode(['status' => 'success', 'msg' => 'Advertisement Created.']);
            } else {
                echo json_encode(['status' => 'error', 'msg' => $insert]);
            }
        }

        if(count($target)) {
            deleteData($con, AD_MAP_TBL, "ad_id = $id");
            foreach ($target as $t => $g)
                createData($con, AD_MAP_TBL, ['ad_id' => $id, 'school_id' => $g]);

        }
    }

    //update ad information if there is an ID on post

    if ($adIsUpload) {
        $partnerInfo = customQuery($con, "SELECT account_id FROM partners_tbl WHERE id = $partnerId");
        $partnerDir = current($partnerInfo)['account_id'];

        $ext = $fileTools->getFileExtension($adImgName);
        $adFileName = $adId . '_banner.' . $ext;
        $filePath = $static . '/partners/' . $partnerDir . '/ads/' . $adFileName;

        // unlink file if exist
        if (file_exists($filePath)) unlink($filePath);
        // then update photo
        saveBase64Image($adImgSource, $adFileName, $static . '/partners/' . $partnerDir . '/ads/');
        updateData($con, PARTNER_ADS_TBL, ['photo' => $adFileName], "id = $id");
    }

}

if (isset($_POST['publish_ad'])) {
    $id = $_POST['id'];
    $status = $_POST['is_publish'];

    $updated = updateData($con, PARTNER_ADS_TBL, ['is_publish' => $status], "id = $id");
    if ($updated == 1) {
        echo json_encode(['status' => 'success', 'msg' => 'Status updated.']);
        exit;
    } else {
        echo json_encode(['status' => 'error', 'msg' => 'action cannot be completed.']);
        exit;
    }
}

function validateImage($image, $width, $height, $allowedMimes = [])
{
    $errors = [];
    $fileTools = new FileTools();
    $dimension = $fileTools->getImageSize($image);
    $mime = explode('/', $dimension['mime']);

    if ($dimension[0] != $width) $errors['err_dimension'] = true;
    if ($dimension[1] != $height) $errors['err_dimension'] = true;
    if (!in_array($mime[1], $allowedMimes)) $errors['err_mime'] =  true;

    return $errors;
}