<?php
session_start();
include '../config/database.config.php';
include '../../tools/dataManager.php';
include '../../tools/validator.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

	$errors = array();
	$username = test_input($_POST['username']);
	$password = $_POST['password'];
	$type = isset($_POST['type']) ? $_POST['type'] : 'admin';

	if($type == 'admin') {
        $user = getData($con, ACCOUNTS_TBL, " account_close = 0 AND email ='$username' OR user_id = '$username' ");
    } else {
        $user = getData($con, PARTNER_TBL, " account_close = 0 AND email ='$username' OR account_id = '$username' ");
    }

    if(count($user)) {
        $currentUser = current($user);
		$dbPass = $currentUser['password'];
		$verified = password_verify($password, $dbPass);


        if(!$verified) {
            $errors['err_message'] = "* The username or password you've entered is incorrect.";
		} else {
		    if(!empty($currentUser['temp_key']))
                updateData($con, ACCOUNTS_TBL, ['temp_key' => null, 'account_verified' => 1], 'id = '.$currentUser['id']);


            /** set session variables */
            $_SESSION['user_id'] = $currentUser['id'];
		    $_SESSION['user_email'] = $currentUser['email'];
		    $_SESSION['user_role'] = $type == 'admin' ? $currentUser['role'] : 3;
            $_SESSION['timestamp'] = time();
            $_SESSION['session_app'] = $type;

            /** return json message */
			echo json_encode(['status' => 4, 'uid' => $currentUser['id']]);
            exit;
		}

	} else {
        $errors['err_message'] = "* The username or password you've entered is incorrect.";
	}

	if(count($errors)) echo json_encode($errors);
    exit;
	
} else {
    /** @var $url string
     * redirect to first page
     */
	$url = '../index.php';
	header('location: '.$url);
}









