<?php
session_start();
include '../config/main.config.php';
include '../config/database.config.php';
include '../../tools/passwordGenerator.php';
include '../../tools/imageManager.php';
include '../../tools/dataManager.php';
include '../../tools/validator.php';
include '../../classes/NotificationManager.php';
include 'setupAccount.php';

/**
 * redirect to profile page if someone tries to visit this page manually
 * access to this page should only be done via POST request
 */
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    $url = '../dashboard.php?p=profile';
    header('location: ' . $url);
}

/** @var  $notificationManager */
$notificationManager = new NotificationManager();

/** save school profile */
if (isset($_POST['form'])) {
    //get all the post data and test the inputs for html special characters, white spaces and slashes

    $id = $_POST['id'];
    $school_name = test_input($_POST['school-name']);
    $short_name = test_input($_POST['school-short-name']);
    $email = isset($_POST['email']) ? test_input($_POST['email']) : NULL;
    $address = test_input($_POST['address']);
    $barangay = test_input($_POST['barangay']);
    $city = test_input($_POST['city']);
    $province = test_input($_POST['province']);
    $postal = empty($_POST['postal']) ? NULL : test_input($_POST['postal']);
    $phone = test_input($_POST['phone']);
    $imgName = $_POST['file-name'];
    $imgSource = $_POST['img-src'];
    $isUpload = $_POST['is-upload'];
    $contacts = json_decode($_POST['contact_person'], true);
    $picture = $imgName;
    $database = test_input($_POST['database-name']);

    //generate password for the user
    $tempKey = generateStrongPassword(8, false, 'luds');
    $hash = password_hash($tempKey, PASSWORD_BCRYPT);

    if ($isUpload) {
        $saveImage = saveBase64Image($imgSource, $imgName, $static . '/schools');
        if ($saveImage)
            $picture = $saveImage['filename'];
    }

    $schoolData = array(
        'name' => $school_name,
        'short_name' => $short_name,
        'email' => $email,
        'picture' => $picture,
        'address' => $address,
        'city' => $city,
        'barangay' => $barangay,
        'province' => $province,
        'postal' => $postal,
        'phone' => $phone,
        'temp_key' => $tempKey,
        'database_name' => $database,
    );

    //update account information if there is an ID on post
    if (intval($id)) {
        $update = updateData($con, SCHOOL_TBL, $schoolData, 'id = ' . $id);
        if ($update == 1) {

            if (count($contacts)) {
                foreach ($contacts as $key => $value) {
                    $value['school_id'] = $id;
                    if (intval($value['id'])) {
                        $contactId = $value['id'];
                        unset($value['id']);
                        $updateContact = updateData($con, SCHOOL_CONTACT_TBL, $value, 'id = ' . $contactId);
                    } else {
                        $insertContact = createData($con, SCHOOL_CONTACT_TBL, $value);
                    }
                }
            }

            $_SESSION['message'] = 'Account Information updated.';
            header('location: ../dashboard.php?p=schools');
        } else {
            echo $update;
        }
    } else { //create a new account
        $getSchools = getData($con, SCHOOL_TBL);
        $count = count($getSchools);
        $counter = $count == 0 ? 1 : $count + 1;
        $counter = $counter < 10 ? '0' . $counter : $counter;

        $accountId = date('Y') . $counter;
        $schoolData['account_id'] = $accountId;

        $insert = createData($con, SCHOOL_TBL, $schoolData);
        if (intval($insert)) {
            if (count($contacts)) {
                foreach ($contacts as $key => $value) {
                    $value['school_id'] = $insert;
                    if (intval($value['id'])) {
                        $contactId = $value['id'];
                        unset($value['id']);
                        $updateContact = updateData($con, SCHOOL_CONTACT_TBL, $value, 'id = ' . $contactId);
                    } else {
                        $insertContact = createData($con, SCHOOL_CONTACT_TBL, $value);
                    }
                }
            }

            setupAccount($insert, ['host' => $db_host, 'user' => $db_user, 'password' => $db_password]);

            $_SESSION['message'] = 'New Account Added.';
            header('location: ../dashboard.php?p=schools');
        } else {
            echo $insert;
        }
    }
}

/**
 * Get contacts information
 */
if (isset($_POST['get_contacts'])) {
    $contacts = getData($con, SCHOOL_CONTACT_TBL, 'school_id = ' . $_POST['school_id'], 'id ASC');
    echo json_encode(['contacts' => $contacts]);
}
