(function ($) {
    var error = 0;
    var errorBox = $('#errorBox');
    var reqErr = $('#errorRequired');

    function onImageChange(e) {
        e.preventDefault();

        console.log(e.currentTarget.files[0]);
        readFile(e.currentTarget.files[0], function(result) {
            $('#account-picture').attr('data-upload', 'true');
            $('#isUpload').val(1);
            $('#file-name').val(e.currentTarget.files[0]['name']);
        });
    }

    function readFile(file, callback) {
        var reader = new FileReader();

        reader.addEventListener('load', function() {
            var result = reader.result;
            $('#account-picture').attr('src', result);
            $('#img-src').val(result);

            callback(result);
        });
        if(file) reader.readAsDataURL(file);
    }

    function hideErrors() {
        $('input, div, img').removeClass('errorBd');
        $('.errorMsg').remove();
        errorBox.hide();
        reqErr.hide();
        error = 0;
    }

    function validateFields() {
        $('input.req').each(function(){
            var value = $(this).val().trim();
            if(value == '') {
                $(this).addClass('errorBd');
                reqErr.show();
                errorBox.show();
                error++;
            }
        });

        $('input[type="email"]').each(function () {
            var valid = true;
            var val = $(this).val();

            if(val.length > 0 ) valid = jmrValidator(val).isEmail();

            if(!valid){
                $(this)
                    .addClass('errorBd')
                    .after('<p class="errorMsg">* Please input a valid email.</p>');
                error++;
            }

        });
    }

    function onSave() {
        hideErrors();
        validateFields();
        var school_id = $('#schoolId').val();
        var contacts  = $('.school-contact');
        var data      = [];


        $.each(contacts, function (i,e) {
           var details = {
               id   : $(e).attr('data-id'),
               name : $(e).find('.contact-name').val().trim(),
               email: $(e).find('.contact-email').val().trim(),
               phone: $(e).find('.contact-mobile').val().trim()
           };
            data.push(details);
        });

        $('#contactPerson').val( JSON.stringify(data) );

        console.log(data);
        if(error == 0) {
            if(school_id.length == 0) $('#setupAccountModal').modal();
            $('#account-form').submit();
        }
    }

    function getContacts() {
        var school_id = $('#schoolId').val();

        if(school_id) {
            var data = {
                get_contacts: true,
                school_id: school_id,
            };
            $.ajax({
                type: "POST",
                url: 'functions/accountsManager.php',
                data: data,
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    var resData = $.parseJSON(response);
                    if (resData.contacts != null) {
                        $.each(resData.contacts, function (i, e) {
                            var template = $('.school-contact').eq(i);
                            template.attr('data-id', e.id);
                            template.find('.contact-name').val(e.name);
                            template.find('.contact-mobile').val(e.phone);
                            template.find('.contact-email').val(e.email);
                        });
                    }
                },
            });
        }
    }

    function showTempKey(e) {
        e.preventDefault();
        var tempKey = $(this).attr('data-key');
        console.log(tempKey);
        $('#pTempKey').html('Temporary Key: <strong>'+ tempKey +'</strong>');
        $('#tempKeyModal').modal();
    }

    function init() {
        getContacts();
        $('.tempKey').on('click', showTempKey);
        $('#saveSchool').click(onSave);
        $('#upload-account-picture').change(onImageChange);
        $('.edit-img-btn').click(function() {
            $('#upload-account-picture').trigger('click');
        });

        $('#accountTable').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "columns": [
                null,
                null,
                null,
                null,
                null,
                {"orderable": false},
                {"orderable": false},
            ],
            "language": {
                "emptyTable": "No Results Found."
            },
            "order": [[ 0, "desc" ]]
        });
    }

    $(document).ready(init)
}(jQuery));